/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.item.components.MSItemComponents;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record CardStoredItemComponent(ItemStack storedStack, boolean isGhostItem) {
    public static final Codec<CardStoredItemComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.fieldOf("item").forGetter(CardStoredItemComponent::storedStack), (App)Codec.BOOL.optionalFieldOf("is_ghost_item", (Object)false).forGetter(CardStoredItemComponent::isGhostItem)).apply((Applicative)instance, CardStoredItemComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CardStoredItemComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, CardStoredItemComponent::storedStack, (StreamCodec)ByteBufCodecs.BOOL, CardStoredItemComponent::isGhostItem, CardStoredItemComponent::new);
    public static final CardStoredItemComponent EMPTY = new CardStoredItemComponent(ItemStack.EMPTY, false);

    public static ItemStack getContainedRealItem(ItemStack card) {
        return Optional.ofNullable((CardStoredItemComponent)card.get(MSItemComponents.CARD_STORED_ITEM)).filter(component -> !component.isGhostItem()).map(CardStoredItemComponent::storedStack).orElse(ItemStack.EMPTY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        boolean bl;
        ItemStack stack;
        if (!(o instanceof CardStoredItemComponent)) return false;
        CardStoredItemComponent cardStoredItemComponent = (CardStoredItemComponent)o;
        try {
            ItemStack itemStack;
            stack = itemStack = cardStoredItemComponent.storedStack();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        boolean ghostItem = bl = cardStoredItemComponent.isGhostItem();
        if (this.isGhostItem != ghostItem) return false;
        if (!ItemStack.matches((ItemStack)this.storedStack, (ItemStack)stack)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return 31 * ItemStack.hashItemAndComponents((ItemStack)this.storedStack) + Boolean.hashCode(this.isGhostItem);
    }
}

