/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.entity.FrogEntity;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public record FrogTraitsComponent(Optional<FrogEntity.FrogVariants> variant, Optional<Double> size, Optional<Integer> skinColor, Optional<FrogEntity.BellyTypes> bellyType, Optional<Integer> bellyColor, Optional<FrogEntity.EyeTypes> eyeType, Optional<Integer> eyeColor) {
    public static final FrogTraitsComponent RANDOM = new FrogTraitsComponent(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    public static final Codec<FrogTraitsComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FrogTraitsComponent.enumCodec(FrogEntity.FrogVariants.class).optionalFieldOf("variant").forGetter(FrogTraitsComponent::variant), (App)Codec.DOUBLE.optionalFieldOf("size").forGetter(FrogTraitsComponent::size), (App)Codec.INT.optionalFieldOf("skin_color").forGetter(FrogTraitsComponent::skinColor), (App)FrogTraitsComponent.enumCodec(FrogEntity.BellyTypes.class).optionalFieldOf("belly_type").forGetter(FrogTraitsComponent::bellyType), (App)Codec.INT.optionalFieldOf("belly_color").forGetter(FrogTraitsComponent::bellyColor), (App)FrogTraitsComponent.enumCodec(FrogEntity.EyeTypes.class).optionalFieldOf("eye_type").forGetter(FrogTraitsComponent::eyeType), (App)Codec.INT.optionalFieldOf("eye_color").forGetter(FrogTraitsComponent::eyeColor)).apply((Applicative)instance, FrogTraitsComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FrogTraitsComponent> STREAM_CODEC = StreamCodec.of((encode, component) -> {
        ByteBufCodecs.optional((StreamCodec)NeoForgeStreamCodecs.enumCodec(FrogEntity.FrogVariants.class)).encode(encode, component.variant);
        ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.DOUBLE).encode(encode, component.size);
        ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT).encode(encode, component.skinColor);
        ByteBufCodecs.optional((StreamCodec)NeoForgeStreamCodecs.enumCodec(FrogEntity.BellyTypes.class)).encode(encode, component.bellyType);
        ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT).encode(encode, component.bellyColor);
        ByteBufCodecs.optional((StreamCodec)NeoForgeStreamCodecs.enumCodec(FrogEntity.EyeTypes.class)).encode(encode, component.eyeType);
        ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT).encode(encode, component.eyeColor);
    }, decode -> new FrogTraitsComponent((Optional)ByteBufCodecs.optional((StreamCodec)NeoForgeStreamCodecs.enumCodec(FrogEntity.FrogVariants.class)).decode(decode), (Optional)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.DOUBLE).decode(decode), (Optional)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT).decode(decode), (Optional)ByteBufCodecs.optional((StreamCodec)NeoForgeStreamCodecs.enumCodec(FrogEntity.BellyTypes.class)).decode(decode), (Optional)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT).decode(decode), (Optional)ByteBufCodecs.optional((StreamCodec)NeoForgeStreamCodecs.enumCodec(FrogEntity.EyeTypes.class)).decode(decode), (Optional)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT).decode(decode)));

    public static FrogTraitsComponent fromFrogEntity(FrogEntity frog) {
        return new FrogTraitsComponent(Optional.of(frog.getFrogVariant()), Optional.of(frog.getFrogSize()), Optional.of(frog.getSkinColor()), Optional.ofNullable(frog.getBellyType()), Optional.of(frog.getBellyColor()), Optional.ofNullable(frog.getEyeType()), Optional.of(frog.getEyeColor()));
    }

    public FrogEntity apply(FrogEntity frog) {
        frog.setFrogVariant(this.variant.orElse(frog.getRandomFrogVariant()));
        frog.setFrogSize(this.size.orElse(frog.getRandom().nextDouble() + 0.6), true);
        frog.setSkinColor(this.skinColor.orElse(frog.random(0xFFFFFF)));
        frog.setBellyType(this.bellyType.orElse(FrogTraitsComponent.randomFromEnum(frog.getRandom(), FrogEntity.BellyTypes.class)));
        frog.setBellyColor(this.bellyColor.orElse(frog.random(0xFFFFFF)));
        frog.setEyeType(this.eyeType.orElse(FrogTraitsComponent.randomFromEnum(frog.getRandom(), FrogEntity.EyeTypes.class)));
        frog.setEyeColor(this.eyeColor.orElse(frog.random(0xFFFFFF)));
        return frog;
    }

    public static <T extends Enum<T>> T randomFromEnum(RandomSource randomSource, Class<T> enumClass) {
        return (T)((Enum[])enumClass.getEnumConstants())[randomSource.nextInt(((Enum[])enumClass.getEnumConstants()).length)];
    }

    public static <T extends Enum<T>> Codec<T> enumCodec(Class<T> enumClass) {
        return StringRepresentable.fromValues(enumClass::getEnumConstants);
    }
}

