/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.components;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import com.mraof.minestuck.item.components.MSItemComponents;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public record HieroglyphCode(Set<Block> hieroglyphs) {
    public static final Codec<HieroglyphCode> CODEC = BuiltInRegistries.BLOCK.byNameCodec().listOf().xmap(Set::copyOf, List::copyOf).xmap(HieroglyphCode::new, HieroglyphCode::hieroglyphs);
    public static final StreamCodec<RegistryFriendlyByteBuf, HieroglyphCode> STREAM_CODEC = ByteBufCodecs.registry((ResourceKey)Registries.BLOCK).apply(ByteBufCodecs.list()).map(Set::copyOf, List::copyOf).map(HieroglyphCode::new, HieroglyphCode::hieroglyphs);
    public static final HieroglyphCode EMPTY = new HieroglyphCode(Collections.emptySet());

    public static Set<Block> getBlocks(ItemStack stack) {
        return ((HieroglyphCode)stack.getOrDefault(MSItemComponents.HIEROGLYPH_CODE, (Object)EMPTY)).hieroglyphs();
    }

    public static void setBlocks(ItemStack stack, Set<Block> hieroglyphs) {
        stack.set(MSItemComponents.HIEROGLYPH_CODE, (Object)new HieroglyphCode(Set.copyOf(hieroglyphs)));
    }

    public static boolean addBlock(ItemStack stack, Block hieroglyph) {
        HieroglyphCode existingCode = (HieroglyphCode)stack.getOrDefault(MSItemComponents.HIEROGLYPH_CODE, (Object)EMPTY);
        if (existingCode.hieroglyphs().contains(hieroglyph)) {
            return false;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)hieroglyph);
        builder.addAll(existingCode.hieroglyphs());
        stack.set(MSItemComponents.HIEROGLYPH_CODE, (Object)new HieroglyphCode((Set<Block>)builder.build()));
        return true;
    }
}

