/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.item.crafting.IrradiatingRecipe;
import com.mraof.minestuck.item.crafting.MSRecipeTypes;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class IrradiatingFallbackRecipe
extends IrradiatingRecipe {
    protected final RecipeType<?> fallbackType;

    public IrradiatingFallbackRecipe(RecipeType<?> fallbackType) {
        super("", CookingBookCategory.MISC, Ingredient.EMPTY, ItemStack.EMPTY, 0.0f, 20);
        this.fallbackType = fallbackType;
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        return true;
    }

    @Override
    public Optional<? extends AbstractCookingRecipe> getCookingRecipe(SingleRecipeInput input, Level level) {
        RecipeManager recipeManager = level.getRecipeManager();
        return this.getFallbackRecipes(recipeManager).filter(recipe -> recipe.matches(input, level)).findFirst();
    }

    private Stream<AbstractCookingRecipe> getFallbackRecipes(RecipeManager recipeManager) {
        return recipeManager.getRecipes().stream().filter(recipe -> recipe.value().getType() == this.fallbackType).flatMap(recipe -> {
            Recipe patt0$temp = recipe.value();
            if (patt0$temp instanceof AbstractCookingRecipe) {
                AbstractCookingRecipe cookingRecipe = (AbstractCookingRecipe)patt0$temp;
                return Stream.of(cookingRecipe);
            }
            return Stream.empty();
        }).filter(o -> !o.isSpecial());
    }

    @Override
    public boolean isFallback() {
        return true;
    }

    @Override
    public boolean isSpecial() {
        return true;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return MSRecipeTypes.IRRADIATING_FALLBACK.get();
    }

    public static class Serializer
    implements RecipeSerializer<IrradiatingFallbackRecipe> {
        private static final MapCodec<IrradiatingFallbackRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.RECIPE_TYPE.byNameCodec().fieldOf("fallback_type").forGetter(recipe -> recipe.fallbackType)).apply((Applicative)instance, IrradiatingFallbackRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, IrradiatingFallbackRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<IrradiatingFallbackRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, IrradiatingFallbackRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static IrradiatingFallbackRecipe fromNetwork(FriendlyByteBuf buffer) {
            ResourceLocation typeName = buffer.readResourceLocation();
            RecipeType fallbackType = (RecipeType)BuiltInRegistries.RECIPE_TYPE.get(typeName);
            if (fallbackType == null) {
                throw new IllegalArgumentException("Can not deserialize unknown Recipe type: " + String.valueOf(typeName));
            }
            return new IrradiatingFallbackRecipe(fallbackType);
        }

        private static void toNetwork(FriendlyByteBuf buffer, IrradiatingFallbackRecipe recipe) {
            buffer.writeResourceLocation(Objects.requireNonNull(BuiltInRegistries.RECIPE_TYPE.getKey(recipe.fallbackType)));
        }
    }
}

