/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.enums;

import net.minecraft.util.StringRepresentable;

public enum EnumShopPoster implements StringRepresentable
{
    FRAYMOTIFS(0, 0, "fraymotifs", "fraymotifs"),
    FOOD(1, 1, "food", "food"),
    HATS(2, 2, "hats", "hats"),
    GENERAL(3, 3, "general", "general"),
    CANDY(4, 4, "candy", "candy");

    private final String name;
    private final String unlocalizedName;
    private final int meta;
    private final int damage;
    private static final EnumShopPoster[] META_LOOKUP;
    private static final EnumShopPoster[] DMG_LOOKUP;

    private EnumShopPoster(int metaIn, int damageIn, String nameIn, String unlocalizedNameIn) {
        this.name = nameIn;
        this.unlocalizedName = unlocalizedNameIn;
        this.meta = metaIn;
        this.damage = damageIn;
    }

    public static EnumShopPoster byMetadata(int meta) {
        if (meta < 0 || meta >= META_LOOKUP.length) {
            meta = 0;
        }
        return META_LOOKUP[meta];
    }

    public static EnumShopPoster byDamage(int damage) {
        if (damage < 0 || damage >= DMG_LOOKUP.length) {
            damage = 0;
        }
        return DMG_LOOKUP[damage];
    }

    public String toString() {
        return this.unlocalizedName;
    }

    public String getSerializedName() {
        return this.name;
    }

    public int getMetadata() {
        return this.meta;
    }

    public int getDamage() {
        return this.damage;
    }

    public String getPosterName() {
        return this.name;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    static {
        META_LOOKUP = new EnumShopPoster[EnumShopPoster.values().length];
        DMG_LOOKUP = new EnumShopPoster[EnumShopPoster.values().length];
        EnumShopPoster[] enumShopPosterArray = EnumShopPoster.values();
        int n = enumShopPosterArray.length;
        for (int i = 0; i < n; ++i) {
            EnumShopPoster enumdyecolor;
            EnumShopPoster.META_LOOKUP[enumdyecolor.getMetadata()] = enumdyecolor = enumShopPosterArray[i];
            EnumShopPoster.DMG_LOOKUP[enumdyecolor.getDamage()] = enumdyecolor;
        }
    }
}

