/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.recipe.GristCostRecipe;
import com.mraof.minestuck.entity.item.GristEntity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.loot.LootModifier;

public class GristLootModifier
extends LootModifier {
    public static final MapCodec<GristLootModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> GristLootModifier.codecStart((RecordCodecBuilder.Instance)instance).and((App)Codec.FLOAT.fieldOf("multiplier").forGetter(modifier -> Float.valueOf(modifier.multiplier))).apply((Applicative)instance, GristLootModifier::new));
    private final float multiplier;

    public GristLootModifier(LootItemCondition[] conditionsIn, float multiplier) {
        super(conditionsIn);
        this.multiplier = multiplier;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (context.hasParam(LootContextParams.ORIGIN)) {
            Vec3 pos = (Vec3)context.getParam(LootContextParams.ORIGIN);
            ObjectArrayList remainingLoot = new ObjectArrayList();
            for (ItemStack stack : generatedLoot) {
                GristSet cost = GristCostRecipe.findCostForItem(stack, null, true, (Level)context.getLevel());
                if (cost != null && this.multiplier != 1.0f) {
                    cost = cost.mutableCopy().scale(this.multiplier, false);
                }
                if (cost != null && !cost.isEmpty()) {
                    GristEntity.spawnGristEntities(cost, (Level)context.getLevel(), pos.x, pos.y, pos.z, context.getRandom(), entity -> entity.setDeltaMovement(entity.getDeltaMovement().multiply(0.5, 0.5, 0.5)));
                    continue;
                }
                remainingLoot.add((Object)stack);
            }
            return remainingLoot;
        }
        return generatedLoot;
    }

    public MapCodec<? extends GristLootModifier> codec() {
        return CODEC;
    }
}

