/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.item.loot.MSLootTables;
import com.mraof.minestuck.world.lands.ILandType;
import com.mraof.minestuck.world.lands.LandTypePair;
import com.mraof.minestuck.world.lands.LandTypes;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import com.mraof.minestuck.world.lands.title.TitleLandType;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LandTableLootEntry
extends LootPoolEntryContainer {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final MapCodec<LandTableLootEntry> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("name").forGetter(entry -> entry.table), (App)Codec.STRING.fieldOf("pool").forGetter(entry -> entry.poolName)).and(LandTableLootEntry.commonFields((RecordCodecBuilder.Instance)instance).t1()).apply((Applicative)instance, LandTableLootEntry::new));
    private final ResourceKey<LootTable> table;
    private final String poolName;
    private static final Field lootEntries = LandTableLootEntry.getLootEntryField();

    private LandTableLootEntry(ResourceKey<LootTable> table, String pool, List<LootItemCondition> conditions) {
        super(conditions);
        this.table = table;
        this.poolName = pool;
    }

    public LootPoolEntryType getType() {
        return MSLootTables.LAND_TABLE_ENTRY.get();
    }

    public boolean expand(LootContext context, Consumer<LootPoolEntry> lootGenCollector) {
        LandTypePair aspects = LandTypePair.getTypes(context.getLevel()).orElse(null);
        if (this.canRun(context) && aspects != null) {
            ResourceKey<LootTable> terrainTableName = this.getTerrainTableName(aspects.getTerrain());
            ResourceKey<LootTable> titleTableName = this.getTitleTableName(aspects.getTitle());
            this.expandFrom(terrainTableName, context, lootGenCollector);
            this.expandFrom(titleTableName, context, lootGenCollector);
            return true;
        }
        return false;
    }

    private ResourceKey<LootTable> getTerrainTableName(TerrainLandType terrainType) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.table.location().getNamespace(), (String)(this.table.location().getPath() + "/terrain/" + Objects.requireNonNull(LandTypes.TERRAIN_REGISTRY.getKey((Object)terrainType)).toString().replace(':', '/'))));
    }

    private ResourceKey<LootTable> getTitleTableName(TitleLandType titleType) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.table.location().getNamespace(), (String)(this.table.location().getPath() + "/title/" + Objects.requireNonNull(LandTypes.TITLE_REGISTRY.getKey((Object)titleType)).toString().replace(':', '/'))));
    }

    private void expandFrom(ResourceKey<LootTable> tableName, LootContext context, Consumer<LootPoolEntry> lootGenCollector) {
        Optional lootTable = context.getResolver().get(Registries.LOOT_TABLE, tableName);
        if (lootTable.isEmpty()) {
            LOGGER.warn("Could not find loot table {}", tableName);
            return;
        }
        final LootPool pool = ((LootTable)((Holder.Reference)lootTable.get()).value()).getPool(this.poolName);
        if (pool == null) {
            LOGGER.warn("Could not find pool by name {} in loot table {}", (Object)this.poolName, tableName);
            return;
        }
        List<LootPoolEntryContainer> entries = this.accessWithReflection(pool);
        if (entries != null) {
            for (LootPoolEntryContainer entry : entries) {
                entry.expand(context, lootGenCollector);
            }
        } else {
            lootGenCollector.accept(new LootPoolEntry(){

                public int getWeight(float v) {
                    return 30;
                }

                public void createItemStack(Consumer<ItemStack> consumer, LootContext lootContext) {
                    pool.addRandomItems(consumer, lootContext);
                }
            });
        }
    }

    public void validate(ValidationContext context) {
        super.validate(context);
        for (ILandType type : LandTypes.TERRAIN_REGISTRY) {
            this.validateRecursiveTable(context, this.getTerrainTableName((TerrainLandType)type));
        }
        for (ILandType type : LandTypes.TITLE_REGISTRY) {
            this.validateRecursiveTable(context, this.getTitleTableName((TitleLandType)type));
        }
    }

    private void validateRecursiveTable(ValidationContext context, ResourceKey<LootTable> tableName) {
        if (context.hasVisitedElement(tableName)) {
            context.reportProblem("Table %s is recursively called".formatted(tableName));
        } else {
            super.validate(context);
            context.resolver().get(Registries.LOOT_TABLE, tableName).ifPresentOrElse(table -> ((LootTable)table.value()).validate(context.enterElement("->{%s}".formatted(tableName), tableName)), () -> {});
        }
    }

    @Nullable
    private static Field getLootEntryField() {
        try {
            return ObfuscationReflectionHelper.findField(LootPool.class, (String)"entries");
        }
        catch (ObfuscationReflectionHelper.UnableToFindFieldException e) {
            LOGGER.error("Unable to get field for lootPool.lootEntries. Will be unable to fully insert loot from land type loot tables.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private List<LootPoolEntryContainer> accessWithReflection(LootPool pool) {
        if (lootEntries == null) {
            return null;
        }
        try {
            return (List)lootEntries.get(pool);
        }
        catch (Exception e) {
            LOGGER.error("Got exception when accessing loot entries field for loot pool. Will use simpler behaviour for this time.", (Throwable)e);
            return null;
        }
    }

    public static BuilderImpl builder(ResourceKey<LootTable> table) {
        return new BuilderImpl(table);
    }

    public static class BuilderImpl
    extends LootPoolEntryContainer.Builder<BuilderImpl> {
        private final ResourceKey<LootTable> table;
        private String pool;

        public BuilderImpl(ResourceKey<LootTable> table) {
            this.table = table;
        }

        protected BuilderImpl getThis() {
            return this;
        }

        public BuilderImpl setPool(String pool) {
            this.pool = pool;
            return this;
        }

        public LootPoolEntryContainer build() {
            if (this.pool == null) {
                throw new IllegalArgumentException("Pool not set");
            }
            return new LandTableLootEntry(this.table, this.pool, this.getConditions());
        }
    }
}

