/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.loot.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.entity.consort.EnumConsort;
import com.mraof.minestuck.item.loot.MSLootTables;
import java.util.List;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

@MethodsReturnNonnullByDefault
public class ConsortLootCondition
implements LootItemCondition {
    public static final MapCodec<ConsortLootCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EnumConsort.SINGLE_OR_LIST_CODEC.fieldOf("consort").forGetter(condition -> condition.consorts)).apply((Applicative)instance, ConsortLootCondition::new));
    private final List<EnumConsort> consorts;

    public ConsortLootCondition(List<EnumConsort> consorts) {
        this.consorts = consorts;
    }

    public LootItemConditionType getType() {
        return MSLootTables.CONSORT_CONDITION.get();
    }

    public boolean test(LootContext context) {
        Entity entity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (entity != null) {
            for (EnumConsort type : this.consorts) {
                if (!type.isConsort(entity)) continue;
                return true;
            }
        }
        return false;
    }

    public static LootItemCondition.Builder builder(EnumConsort ... consorts) {
        return () -> new ConsortLootCondition(List.of(consorts));
    }
}

