/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.loot.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.item.loot.MSLootTables;
import com.mraof.minestuck.world.lands.LandTypePair;
import com.mraof.minestuck.world.lands.LandTypes;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import com.mraof.minestuck.world.lands.title.TitleLandType;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public record LandTypeLootCondition(HolderSet<TerrainLandType> terrainTypes, HolderSet<TitleLandType> titleTypes, boolean inverted) implements LootItemCondition
{
    public static final MapCodec<LandTypeLootCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList(LandTypes.TERRAIN_KEY).fieldOf("terrain_type").forGetter(LandTypeLootCondition::terrainTypes), (App)RegistryCodecs.homogeneousList(LandTypes.TITLE_KEY).fieldOf("title_type").forGetter(LandTypeLootCondition::titleTypes), (App)Codec.BOOL.fieldOf("inverted").orElse((Object)false).forGetter(LandTypeLootCondition::inverted)).apply((Applicative)instance, LandTypeLootCondition::new));

    public LootItemConditionType getType() {
        return MSLootTables.LAND_TYPE_CONDITION.get();
    }

    public boolean test(LootContext context) {
        ServerLevel level = context.getLevel();
        LandTypePair aspects = LandTypePair.getTypes(level).orElse(null);
        if (aspects != null && (aspects.getTerrain().is(this.terrainTypes) || aspects.getTitle().is(this.titleTypes))) {
            return !this.inverted;
        }
        return this.inverted;
    }
}

