/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.item.BoondollarsItem;
import com.mraof.minestuck.item.loot.MSLootTables;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SetBoondollarCount
extends LootItemConditionalFunction {
    public static final MapCodec<SetBoondollarCount> CODEC = RecordCodecBuilder.mapCodec(instance -> SetBoondollarCount.commonFields((RecordCodecBuilder.Instance)instance).and((App)NumberProviders.CODEC.fieldOf("count").forGetter(function -> function.countRange)).apply((Applicative)instance, SetBoondollarCount::new));
    private final NumberProvider countRange;

    public SetBoondollarCount(List<LootItemCondition> conditionsIn, NumberProvider countRangeIn) {
        super(conditionsIn);
        this.countRange = countRangeIn;
    }

    public LootItemFunctionType getType() {
        return MSLootTables.SET_BOONDOLLAR_FUNCTION.get();
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        return BoondollarsItem.setCount(stack, this.countRange.getInt(context));
    }

    public static LootItemConditionalFunction.Builder<?> builder(NumberProvider range) {
        return SetBoondollarCount.simpleBuilder(conditions -> new SetBoondollarCount((List<LootItemCondition>)conditions, range));
    }
}

