/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.loot.functions;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.item.components.HieroglyphCode;
import com.mraof.minestuck.item.loot.MSLootTables;
import com.mraof.minestuck.util.MSTags;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SetSburbCodeFragments
extends LootItemConditionalFunction {
    public static final MapCodec<SetSburbCodeFragments> CODEC = RecordCodecBuilder.mapCodec(instance -> SetSburbCodeFragments.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, SetSburbCodeFragments::new));

    public SetSburbCodeFragments(List<LootItemCondition> conditionsIn) {
        super(conditionsIn);
    }

    public LootItemFunctionType<SetSburbCodeFragments> getType() {
        return MSLootTables.SET_SBURB_CODE_FRAGMENT_FUNCTION.get();
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        HieroglyphCode.setBlocks(stack, this.pickRandomHieroglyphs(context.getRandom()));
        return stack;
    }

    private Set<Block> pickRandomHieroglyphs(RandomSource random) {
        Optional hieroglyphs = BuiltInRegistries.BLOCK.getTag(MSTags.Blocks.GREEN_HIEROGLYPHS);
        if (hieroglyphs.isEmpty() || ((HolderSet.Named)hieroglyphs.get()).size() == 0) {
            return Collections.emptySet();
        }
        HashSet<Block> pickedBlocks = new HashSet<Block>();
        int numberOfIterations = Math.max(1, random.nextInt(Math.min(3, ((HolderSet.Named)hieroglyphs.get()).size())));
        for (int iterate = 0; iterate < numberOfIterations; ++iterate) {
            ((HolderSet.Named)hieroglyphs.get()).getRandomElement(random).ifPresent(holder -> pickedBlocks.add((Block)holder.value()));
        }
        return pickedBlocks;
    }

    public static LootItemConditionalFunction.Builder<?> builder() {
        return SetSburbCodeFragments.simpleBuilder(SetSburbCodeFragments::new);
    }
}

