/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.weapon;

import com.mraof.minestuck.advancements.MSCriteriaTriggers;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;

public interface DestroyBlockEffect {
    public static final DestroyBlockEffect DOUBLE_FARM = (stack, levelIn, state, pos, entity) -> {
        CropBlock crop;
        Block patt0$temp = state.getBlock();
        if (patt0$temp instanceof CropBlock && (crop = (CropBlock)patt0$temp).isMaxAge(state)) {
            CropBlock.dropResources((BlockState)state, (Level)levelIn, (BlockPos)pos);
        }
    };

    public void onDestroyBlock(ItemStack var1, Level var2, BlockState var3, BlockPos var4, LivingEntity var5);

    public static DestroyBlockEffect extraHarvests(boolean melonOverload, float percentage, int maxBonusItems, Supplier<Item> itemDropped, Supplier<Block> harvestedBlock) {
        return (stack, levelIn, state, pos, entity) -> {
            if (state == ((Block)harvestedBlock.get()).defaultBlockState() && !levelIn.isClientSide) {
                int harvestCounter;
                float i = entity.getRandom().nextFloat();
                for (harvestCounter = 0; i <= percentage && harvestCounter < maxBonusItems; ++harvestCounter) {
                    ItemStack harvestItemStack = new ItemStack((ItemLike)itemDropped.get(), 1);
                    ItemEntity item = new ItemEntity(levelIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), harvestItemStack);
                    levelIn.addFreshEntity((Entity)item);
                    i = entity.getRandom().nextFloat();
                }
                if (melonOverload && harvestCounter >= 9) {
                    entity.sendSystemMessage((Component)Component.translatable((String)(stack.getDescriptionId() + ".message")).withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}));
                    entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 1800, 3));
                    entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 1800, 3));
                    entity.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 1800, 3));
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)entity;
                        MSCriteriaTriggers.MELON_OVERLOAD.get().trigger(player);
                    }
                }
            }
        };
    }
}

