/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.weapon;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.item.weapon.DestroyBlockEffect;
import com.mraof.minestuck.item.weapon.WeaponItem;
import com.mraof.minestuck.util.MSTags;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class FarmineEffect
implements DestroyBlockEffect {
    private int radius;
    private int terminus;
    private final HashMap<Block, HashSet<Block>> farMineEquivalencies = new HashMap();

    public FarmineEffect(int radius, int terminus) {
        this.redefineLimiters(radius, terminus);
        this.initializeFarMineLists();
    }

    private void initializeFarMineLists() {
        this.addAssociation(Blocks.DIRT, Blocks.GRASS_BLOCK);
        this.addAssociation(Blocks.DIRT, Blocks.MYCELIUM);
        this.addAssociation(Blocks.DIRT, Blocks.DIRT_PATH);
        this.addAssociation(Blocks.END_STONE, (Block)MSBlocks.END_GRASS.get());
        this.addOneWayAssociation(Blocks.COBBLESTONE, Blocks.INFESTED_COBBLESTONE);
        this.addOneWayAssociation(Blocks.STONE, Blocks.INFESTED_STONE);
        this.addOneWayAssociation(Blocks.STONE_BRICKS, Blocks.INFESTED_STONE_BRICKS);
        this.addOneWayAssociation(Blocks.CHISELED_STONE_BRICKS, Blocks.INFESTED_CHISELED_STONE_BRICKS);
        this.addOneWayAssociation(Blocks.CRACKED_STONE_BRICKS, Blocks.INFESTED_CRACKED_STONE_BRICKS);
        this.addOneWayAssociation(Blocks.MOSSY_STONE_BRICKS, Blocks.INFESTED_MOSSY_STONE_BRICKS);
    }

    @Override
    public void onDestroyBlock(ItemStack stack, Level level, BlockState blockState, BlockPos pos, LivingEntity playerIn) {
        if (level.isClientSide) {
            return;
        }
        if (!stack.isCorrectToolForDrops(blockState) || !(playerIn instanceof Player) || playerIn.isShiftKeyDown() || this.terminus == 1 || this.radius == 0 || (double)Math.abs(blockState.getDestroySpeed((BlockGetter)level, pos)) < 1.0E-9) {
            return;
        }
        int rad = blockState.is(MSTags.Blocks.FARMINE_BREAK_BLACKLIST) || blockState.getBlock().defaultDestroyTime() > ((WeaponItem)stack.getItem()).getEfficiency() ? 1 : this.radius;
        HashSet<BlockPos> blocksToBreak = this.getConnectedBlocks(pos, blockState.getBlock(), rad, Math.min(this.terminus, stack.getMaxDamage() - stack.getDamageValue()), level);
        for (BlockPos blockToBreak : blocksToBreak) {
            BlockState state = level.getBlockState(blockToBreak);
            this.harvestBlock(level, state.getBlock(), blockToBreak, state, playerIn, stack);
        }
        stack.hurtAndBreak(blocksToBreak.size(), playerIn, EquipmentSlot.MAINHAND);
    }

    private boolean harvestBlock(Level level, Block block, BlockPos pos, BlockState state, LivingEntity playerIn, ItemStack stack) {
        Player player = (Player)playerIn;
        BlockEntity te = level.getBlockEntity(pos);
        if (block.onDestroyedByPlayer(state, level, pos, player, true, level.getFluidState(pos))) {
            block.destroy((LevelAccessor)level, pos, state);
            block.playerDestroy(level, player, pos, state, te, stack);
            return true;
        }
        return false;
    }

    private int distBetween(BlockPos a, BlockPos b) {
        return Math.max(Math.max(Math.abs(a.getX() - b.getX()), Math.abs(a.getY() - b.getY())), Math.abs(a.getZ() - b.getZ()));
    }

    private HashSet<BlockPos> getConnectedBlocks(BlockPos start, Block block, int radius, int max, Level level) {
        HashSet<BlockPos> blocksToBreak = new HashSet<BlockPos>();
        HashSet<Object> equals = this.farMineEquivalencies.get(block);
        if (equals == null) {
            equals = new HashSet();
        }
        if (radius != 0) {
            LinkedList<BlockPos> edges = new LinkedList<BlockPos>();
            edges.add(start);
            do {
                BlockPos edge = (BlockPos)edges.poll();
                blocksToBreak.add(edge);
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        for (int k = -1; k < 2; ++k) {
                            if (i == 0 && j == 0 && k == 0) continue;
                            BlockPos newBlockPos = new BlockPos(edge.getX() + i, edge.getY() + j, edge.getZ() + k);
                            BlockState newState = level.getBlockState(newBlockPos);
                            Block newBlock = newState.getBlock();
                            if (blocksToBreak.contains(newBlockPos) || edges.contains(newBlockPos) || this.distBetween(start, newBlockPos) > radius || !equals.contains(newBlock) && !newBlock.equals(block)) continue;
                            edges.add(newBlockPos);
                        }
                    }
                }
            } while (blocksToBreak.size() <= max && edges.size() > 0);
        } else {
            blocksToBreak.add(start);
        }
        return blocksToBreak;
    }

    public FarmineEffect redefineLimiters(int r, int t) {
        this.terminus = Math.max(1, t);
        this.radius = Math.max(0, Math.min(r, this.terminus));
        return this;
    }

    public void addAssociation(Block a, Block b) {
        this.addOneWayAssociation(a, b);
        this.addOneWayAssociation(b, a);
    }

    public void addOneWayAssociation(Block a, Block b) {
        HashSet<Object> equalToA = this.farMineEquivalencies.get(a);
        if (equalToA == null) {
            equalToA = new HashSet();
            this.farMineEquivalencies.put(a, equalToA);
        }
        equalToA.add(b);
    }
}

