/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.weapon;

import com.mraof.minestuck.item.MSItems;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public interface FinishUseItemEffect {
    public static final FinishUseItemEffect SPAWN_BREADCRUMBS = (stack, level, entityIn) -> {
        if (!entityIn.level().isClientSide && entityIn instanceof Player) {
            Player player = (Player)entityIn;
            int num = entityIn.getRandom().nextInt(10);
            ItemStack crumbs = new ItemStack((ItemLike)MSItems.BREADCRUMBS.get(), num);
            player.addItem(crumbs);
        }
        return stack;
    };
    public static final FinishUseItemEffect SHARPEN_CANDY_CANE = (stack, worldIn, entityIn) -> {
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            if (!entityIn.level().isClientSide) {
                player.addItem(new ItemStack((ItemLike)MSItems.SHARP_CANDY_CANE.get(), 1));
            }
        }
        stack.hurtAndBreak(999, entityIn, EquipmentSlot.MAINHAND);
        return stack;
    };

    public ItemStack onItemUseFinish(ItemStack var1, Level var2, LivingEntity var3);

    public static FinishUseItemEffect foodEffect(int healAmount, float saturationModifier) {
        return FinishUseItemEffect.foodEffect(healAmount, saturationModifier, 50);
    }

    public static FinishUseItemEffect foodEffect(int healAmount, float saturationModifier, int damageTaken) {
        return (stack, worldIn, entityIn) -> {
            stack.hurtAndBreak(damageTaken, entityIn, EquipmentSlot.MAINHAND);
            if (entityIn instanceof Player) {
                Player player = (Player)entityIn;
                player.getFoodData().eat(healAmount, saturationModifier);
                worldIn.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_BURP, SoundSource.PLAYERS, 0.5f, worldIn.random.nextFloat() * 0.1f + 0.9f);
            }
            return stack;
        };
    }

    public static FinishUseItemEffect potionEffect(Supplier<MobEffectInstance> effect, float probability) {
        return (stack, worldIn, entityLiving) -> {
            if (!worldIn.isClientSide && worldIn.random.nextFloat() < probability) {
                entityLiving.addEffect((MobEffectInstance)effect.get());
            }
            return stack;
        };
    }
}

