/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.weapon;

import com.mraof.minestuck.player.EnumAspect;
import com.mraof.minestuck.player.Title;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface InventoryTickEffect {
    public static final InventoryTickEffect BREATH_SLOW_FALLING = InventoryTickEffect.passiveAspectEffect(EnumAspect.BREATH, () -> new MobEffectInstance(MobEffects.SLOW_FALLING, 2, 2));
    public static final InventoryTickEffect DROP_WHEN_IN_WATER = (stack, level, entityIn, itemSlot, isSelected) -> {
        if (isSelected && entityIn.isInWater() && entityIn instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entityIn;
            stack.hurtAndBreak(70, living, EquipmentSlot.MAINHAND);
            ItemEntity weapon = new ItemEntity(entityIn.level(), entityIn.getX(), entityIn.getY(), entityIn.getZ(), stack.copy());
            weapon.getItem().setCount(1);
            weapon.setPickUpDelay(40);
            entityIn.level().addFreshEntity((Entity)weapon);
            stack.shrink(1);
            entityIn.hurt(level.damageSources().lightningBolt(), 5.0f);
        }
    };

    public void inventoryTick(ItemStack var1, Level var2, Entity var3, int var4, boolean var5);

    public static InventoryTickEffect passiveAspectEffect(EnumAspect aspect, Supplier<MobEffectInstance> effect) {
        return (stack, worldIn, entityIn, itemSlot, isSelected) -> {
            ServerPlayer player;
            if (isSelected && entityIn instanceof ServerPlayer && Title.isPlayerOfAspect(player = (ServerPlayer)entityIn, aspect)) {
                player.addEffect((MobEffectInstance)effect.get());
            }
        };
    }
}

