/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.weapon;

import com.mraof.minestuck.effects.CreativeShockEffect;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public interface ItemRightClickEffect {
    public static final ItemRightClickEffect ACTIVE_HAND = (world, player, hand) -> {
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
    };
    public static final ItemRightClickEffect EIGHTBALL = (world, player, hand) -> {
        if (world.isClientSide) {
            int key = player.getRandom().nextInt(20);
            player.sendSystemMessage((Component)Component.translatable((String)("message.eightball." + key)).withStyle(ChatFormatting.BLUE));
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    };

    public static ItemRightClickEffect switchTo(Holder<Item> otherItem) {
        return (world, player, hand) -> {
            ItemStack itemStackIn = player.getItemInHand(hand);
            if (player.isShiftKeyDown()) {
                ItemStack newItem = new ItemStack(otherItem, itemStackIn.getCount(), itemStackIn.getComponentsPatch());
                return InteractionResultHolder.success((Object)newItem);
            }
            return InteractionResultHolder.pass((Object)itemStackIn);
        };
    }

    public static ItemRightClickEffect summonFireball() {
        return (world, player, hand) -> {
            ItemStack itemStackIn = player.getItemInHand(hand);
            world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BLAZE_SHOOT, SoundSource.PLAYERS, 1.0f, 0.8f);
            AABB axisalignedbb = player.getBoundingBox().inflate(32.0, 32.0, 32.0);
            List list = player.level().getEntitiesOfClass(LivingEntity.class, axisalignedbb);
            list.remove(player);
            if (!list.isEmpty() && !world.isClientSide) {
                for (LivingEntity livingentity : list) {
                    LargeFireball fireball = new LargeFireball(world, (LivingEntity)player, new Vec3(0.0, -8.0, 0.0), 1);
                    fireball.setPos(livingentity.getX() + (double)(player.getRandom().nextInt(6) - 3), livingentity.getY() + 40.0, livingentity.getZ() + (double)(player.getRandom().nextInt(6) - 3));
                    player.getCooldowns().addCooldown(itemStackIn.getItem(), 20);
                    itemStackIn.hurtAndBreak(2, (LivingEntity)player, EquipmentSlot.MAINHAND);
                    world.addFreshEntity((Entity)fireball);
                }
            } else if (!world.isClientSide) {
                LargeFireball fireball = new LargeFireball(world, (LivingEntity)player, new Vec3(0.0, -8.0, 0.0), 1);
                fireball.setPos(player.getX() + (double)(player.getRandom().nextInt(20) - 10), player.getY() + 40.0, player.getZ() + (double)(player.getRandom().nextInt(20) - 10));
                player.getCooldowns().addCooldown(itemStackIn.getItem(), 20);
                itemStackIn.hurtAndBreak(2, (LivingEntity)player, EquipmentSlot.MAINHAND);
                world.addFreshEntity((Entity)fireball);
            }
            return InteractionResultHolder.pass((Object)itemStackIn);
        };
    }

    public static ItemRightClickEffect extinguishFire(int mod) {
        return ItemRightClickEffect.withoutCreativeShock((world, player, hand) -> {
            ItemStack itemStackIn = player.getItemInHand(hand);
            if (!world.isClientSide) {
                world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDER_DRAGON_FLAP, SoundSource.PLAYERS, 1.0f, 1.4f);
                for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)player.blockPosition().offset(2 * mod, mod, 2 * mod), (BlockPos)player.blockPosition().offset(-2 * mod, -1 * mod, -2 * mod))) {
                    BlockState blockState = world.getBlockState(blockPos);
                    if (blockState.getBlock() != Blocks.FIRE) continue;
                    world.setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
                    world.playSound(null, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 1.0f);
                }
                AABB axisalignedbb = player.getBoundingBox().inflate((double)(2 * mod), (double)mod, (double)(2 * mod));
                List list = player.level().getEntitiesOfClass(LivingEntity.class, axisalignedbb);
                for (LivingEntity livingentity : list) {
                    if (livingentity.getRemainingFireTicks() <= 0) continue;
                    livingentity.clearFire();
                    world.playSound(null, livingentity.getX(), livingentity.getY(), livingentity.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.NEUTRAL, 0.5f, 1.0f);
                }
                player.swing(hand, true);
                player.getCooldowns().addCooldown(itemStackIn.getItem(), 15);
                itemStackIn.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            return InteractionResultHolder.pass((Object)itemStackIn);
        });
    }

    public static ItemRightClickEffect absorbFluid(Supplier<Block> fluidBlock, Holder<Item> otherItem) {
        return ItemRightClickEffect.withoutCreativeShock((world, player, hand) -> {
            ItemStack itemStack = player.getItemInHand(hand);
            BlockHitResult blockraytraceresult = ItemRightClickEffect.getPlayerPOVHitResult(world, player);
            BlockPos rayTracedPos = blockraytraceresult.getBlockPos();
            if (blockraytraceresult.getType() == HitResult.Type.BLOCK && world.getBlockState(rayTracedPos).getBlock() == fluidBlock.get()) {
                world.setBlockAndUpdate(rayTracedPos, Blocks.AIR.defaultBlockState());
                ItemStack newItem = new ItemStack(otherItem, itemStack.getCount(), itemStack.getComponentsPatch());
                world.playSound(null, rayTracedPos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 2.0f);
                player.getCooldowns().addCooldown((Item)otherItem.value(), 5);
                return InteractionResultHolder.success((Object)newItem);
            }
            return InteractionResultHolder.fail((Object)itemStack);
        });
    }

    public static ItemRightClickEffect playerPotionEffect(Supplier<MobEffectInstance> effect, int durabilityCost, int cooldownTickDuration) {
        return (world, player, hand) -> {
            player.addEffect((MobEffectInstance)effect.get());
            ItemStack itemStack = player.getItemInHand(hand);
            player.swing(hand, true);
            player.getCooldowns().addCooldown(itemStack.getItem(), cooldownTickDuration);
            itemStack.hurtAndBreak(durabilityCost, (LivingEntity)player, EquipmentSlot.MAINHAND);
            return InteractionResultHolder.pass((Object)itemStack);
        };
    }

    public static BlockHitResult getPlayerPOVHitResult(Level level, Player playerEntity) {
        float xRot = playerEntity.getXRot();
        float yRot = playerEntity.getYRot();
        Vec3 eyeVec = playerEntity.getEyePosition(1.0f);
        float f2 = Mth.cos((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-xRot * ((float)Math.PI / 180)));
        float yComponent = Mth.sin((float)(-xRot * ((float)Math.PI / 180)));
        float xComponent = f3 * f4;
        float zComponent = f2 * f4;
        double reachDistance = playerEntity.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
        Vec3 endVec = eyeVec.add((double)xComponent * reachDistance, (double)yComponent * reachDistance, (double)zComponent * reachDistance);
        return level.clip(new ClipContext(eyeVec, endVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.SOURCE_ONLY, (Entity)playerEntity));
    }

    public static ItemRightClickEffect withoutCreativeShock(ItemRightClickEffect effect) {
        return (world, player, hand) -> {
            ItemStack itemStackIn = player.getItemInHand(hand);
            if (!CreativeShockEffect.doesCreativeShockLimit(player, 0)) {
                return effect.onRightClick(world, player, hand);
            }
            return InteractionResultHolder.pass((Object)itemStackIn);
        };
    }

    public InteractionResultHolder<ItemStack> onRightClick(Level var1, Player var2, InteractionHand var3);
}

