/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.weapon;

import com.mraof.minestuck.client.util.MagicEffect;
import com.mraof.minestuck.entity.underling.UnderlingEntity;
import com.mraof.minestuck.item.weapon.ItemRightClickEffect;
import com.mraof.minestuck.network.MagicAOEEffectPacket;
import com.mraof.minestuck.player.Echeladder;
import com.mraof.minestuck.util.MSSoundEvents;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.network.PacketDistributor;

public class MagicAOERightClickEffect
implements ItemRightClickEffect {
    private final float radius;
    private final int damage;
    @Nullable
    private final MagicEffect.AOEType type;
    private final Consumer<LivingEntity> targetEffect;
    private static final TargetingConditions visiblePredicate = TargetingConditions.forCombat();
    public static final MagicAOERightClickEffect STANDARD_MAGIC = new MagicAOERightClickEffect(3.0f, 2, MagicEffect.AOEType.ENCHANT);
    public static final MagicAOERightClickEffect WATER_MAGIC = new MagicAOERightClickEffect(3.25f, 3, MagicEffect.AOEType.WATER){

        @Override
        protected float calculateDamage(ServerPlayer player, LivingEntity target, int damage) {
            return super.calculateDamage(player, target, damage) + (float)(target.isSensitiveToWater() ? 5 : 0);
        }
    };
    public static final MagicAOERightClickEffect FIRE_MAGIC = new MagicAOERightClickEffect(3.25f, 3, MagicEffect.AOEType.FIRE, target -> target.igniteForSeconds(5.0f));

    protected MagicAOERightClickEffect(float radius, int damage, @Nullable MagicEffect.AOEType type) {
        this(radius, damage, type, ignored -> {});
    }

    protected MagicAOERightClickEffect(float radius, int damage, @Nullable MagicEffect.AOEType type, Consumer<LivingEntity> targetEffect) {
        this.radius = radius;
        this.damage = damage;
        this.type = type;
        this.targetEffect = targetEffect;
    }

    @Override
    public InteractionResultHolder<ItemStack> onRightClick(Level level, Player player, InteractionHand hand) {
        ItemStack itemStackIn = player.getItemInHand(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.magicAttack(serverPlayer);
        }
        if (player.isCreative()) {
            player.getCooldowns().addCooldown(itemStackIn.getItem(), 10);
        } else {
            player.getCooldowns().addCooldown(itemStackIn.getItem(), 100);
        }
        player.swing(hand, true);
        itemStackIn.hurtAndBreak(6, (LivingEntity)player, EquipmentSlot.MAINHAND);
        player.awardStat(Stats.ITEM_USED.get((Object)itemStackIn.getItem()));
        return InteractionResultHolder.success((Object)itemStackIn);
    }

    private void magicAttack(ServerPlayer player) {
        BlockPos playerPos = player.blockPosition();
        ServerLevel level = player.serverLevel();
        level.playSound(null, player.getX(), player.getY(), player.getZ(), MSSoundEvents.ITEM_MAGIC_CAST.get(), SoundSource.PLAYERS, 1.0f, 1.2f);
        if (player.isInWall()) {
            return;
        }
        AABB aabb = new AABB(playerPos).inflate((double)this.radius);
        List targets = level.getNearbyEntities(LivingEntity.class, visiblePredicate, (LivingEntity)player, aabb);
        targets.remove(player);
        for (LivingEntity target : targets) {
            if (target.isAlliedTo((Entity)player)) continue;
            float talliedDamage = this.calculateDamage(player, target, this.damage);
            target.hurt(level.damageSources().indirectMagic((Entity)player, (Entity)player), talliedDamage);
            this.targetEffect.accept(target);
        }
        this.sendEffectPacket(level, aabb);
    }

    protected void sendEffectPacket(ServerLevel level, AABB aabb) {
        if (this.type != null) {
            Vec3 centerPos = aabb.getCenter();
            Vec3 minAOEBound = new Vec3(aabb.minX, aabb.minY, aabb.minZ);
            Vec3 maxAOEBound = new Vec3(aabb.maxX, aabb.maxY, aabb.maxZ);
            PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)centerPos.x, (double)centerPos.y, (double)centerPos.z, (double)64.0, (CustomPacketPayload)new MagicAOEEffectPacket(this.type, minAOEBound, maxAOEBound), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected float calculateDamage(ServerPlayer player, LivingEntity target, int damage) {
        if (!(player instanceof FakePlayer)) {
            int playerRung = Echeladder.get(player).getRung();
            return (float)damage + (target instanceof UnderlingEntity ? (float)playerRung / 5.0f : (float)playerRung / 10.0f);
        }
        return damage;
    }
}

