/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.weapon;

import com.mraof.minestuck.block.EnumCassetteType;
import com.mraof.minestuck.inventory.musicplayer.CassetteContainerMenu;
import com.mraof.minestuck.inventory.musicplayer.MusicPlaying;
import com.mraof.minestuck.item.CassetteItem;
import com.mraof.minestuck.item.weapon.WeaponItem;
import com.mraof.minestuck.network.MusicPlayerPacket;
import com.mraof.minestuck.util.MSAttachments;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="minestuck")
public class MusicPlayerWeapon
extends WeaponItem {
    public static final String TITLE = "minestuck.music_player";
    private final float volume;
    private final float pitch;

    public MusicPlayerWeapon(WeaponItem.Builder builder, Item.Properties properties, float volume, float pitch) {
        super(builder, properties.component(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY));
        this.volume = volume;
        this.pitch = pitch;
    }

    public MusicPlayerWeapon(WeaponItem.Builder builder, Item.Properties properties) {
        super(builder, properties);
        this.volume = 4.0f;
        this.pitch = 1.0f;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack musicPlayer = playerIn.getItemInHand(handIn);
        ItemStack itemInMusicPlayer = ((ItemContainerContents)musicPlayer.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyOne();
        MusicPlaying musicPlayingCap = (MusicPlaying)playerIn.getData(MSAttachments.MUSIC_PLAYING);
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            if (playerIn.isCrouching()) {
                Item item = itemInMusicPlayer.getItem();
                if (item instanceof CassetteItem) {
                    MusicPlayerPacket packet;
                    CassetteItem cassette = (CassetteItem)item;
                    if (musicPlayingCap.getCassetteType() == EnumCassetteType.NONE) {
                        packet = MusicPlayerPacket.createPacket(playerIn, cassette.cassetteType, this.volume, this.pitch);
                        musicPlayingCap.setMusicPlaying(musicPlayer, cassette.cassetteType);
                    } else {
                        packet = MusicPlayerPacket.createPacket(playerIn, EnumCassetteType.NONE, 0.0f, 0.0f);
                        musicPlayingCap.setMusicPlaying(ItemStack.EMPTY, EnumCassetteType.NONE);
                    }
                    PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)playerIn, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            } else {
                MusicPlayerPacket packet = MusicPlayerPacket.createPacket(playerIn, EnumCassetteType.NONE, 0.0f, 0.0f);
                musicPlayingCap.setMusicPlaying(ItemStack.EMPTY, EnumCassetteType.NONE);
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)playerIn, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
                serverPlayer.openMenu((MenuProvider)new SimpleMenuProvider((pContainerId, pInventory, pPlayer) -> new CassetteContainerMenu(pContainerId, pInventory, musicPlayer, itemInMusicPlayer), (Component)Component.translatable((String)TITLE)));
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)musicPlayer, (boolean)level.isClientSide);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        if (MusicPlayerWeapon.hasCassette(stack)) {
            return super.getDefaultAttributeModifiers(stack);
        }
        return ItemAttributeModifiers.EMPTY;
    }

    @SubscribeEvent
    public static void playerTick(PlayerTickEvent.Post tickEvent) {
        if (!tickEvent.getEntity().level().isClientSide() && tickEvent.getEntity().isAlive()) {
            EnumCassetteType.EffectContainer effectContainer;
            Player player = tickEvent.getEntity();
            MusicPlaying musicPlayingCap = (MusicPlaying)player.getData(MSAttachments.MUSIC_PLAYING);
            if ((player.getItemInHand(InteractionHand.MAIN_HAND) != musicPlayingCap.getCurrentMusicPlayer() && player.getItemInHand(InteractionHand.OFF_HAND) != musicPlayingCap.getCurrentMusicPlayer() || musicPlayingCap.getCurrentMusicPlayer().isEmpty()) && musicPlayingCap.getCassetteType() != EnumCassetteType.NONE) {
                MusicPlayerPacket packet = MusicPlayerPacket.createPacket(player, EnumCassetteType.NONE, 0.0f, 0.0f);
                musicPlayingCap.setMusicPlaying(ItemStack.EMPTY, EnumCassetteType.NONE);
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (player.level().getGameTime() % 50L == 0L && musicPlayingCap.getCassetteType() != EnumCassetteType.NONE && !(effectContainer = musicPlayingCap.getCassetteType().getEffectContainer()).onHit()) {
                player.addEffect(effectContainer.effect().get());
            }
        }
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        MusicPlaying musicPlaying = (MusicPlaying)attacker.getData(MSAttachments.MUSIC_PLAYING);
        if (musicPlaying.getCassetteType() != EnumCassetteType.NONE && musicPlaying.getCurrentMusicPlayer() == stack) {
            RandomSource r = attacker.level().getRandom();
            double attackerLuckValue = 0.0;
            double targetLuckValue = 0.0;
            if (attacker.getAttributes().hasAttribute(Attributes.LUCK)) {
                attackerLuckValue = attacker.getAttributeValue(Attributes.LUCK);
            }
            if (target.getAttributes().hasAttribute(Attributes.LUCK)) {
                targetLuckValue = target.getAttributeValue(Attributes.LUCK);
            }
            EnumCassetteType.EffectContainer effectContainer = musicPlaying.getCassetteType().getEffectContainer();
            double chanceToHit = effectContainer.applyingChance();
            if ((chanceToHit = chanceToHit + attackerLuckValue / 10.0 - targetLuckValue / 10.0) > (double)r.nextFloat() && effectContainer.onHit()) {
                target.addEffect(effectContainer.effect().get());
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public static boolean hasCassette(ItemStack stack) {
        return !((ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyOne().isEmpty();
    }
}

