/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.weapon;

import com.google.common.collect.ImmutableList;
import com.mraof.minestuck.effects.CreativeShockEffect;
import com.mraof.minestuck.entity.MSAttributes;
import com.mraof.minestuck.entity.underling.UnderlingEntity;
import com.mraof.minestuck.event.ServerEventHandler;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.loot.MSLootTables;
import com.mraof.minestuck.network.PushPlayerPacket;
import com.mraof.minestuck.player.EnumAspect;
import com.mraof.minestuck.player.Title;
import com.mraof.minestuck.util.MSDamageSources;
import com.mraof.minestuck.util.MSTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.network.PacketDistributor;

public interface OnHitEffect {
    public static final OnHitEffect RAGE_STRENGTH = OnHitEffect.requireAspect(EnumAspect.RAGE, OnHitEffect.chanceWithCritMod(OnHitEffect.userPotionEffect(() -> new MobEffectInstance(MobEffects.DAMAGE_BOOST, 80, 1))));
    public static final OnHitEffect HOPE_RESISTANCE = OnHitEffect.requireAspect(EnumAspect.HOPE, OnHitEffect.chanceWithCritMod(OnHitEffect.userPotionEffect(() -> new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 120, 2))));
    public static final OnHitEffect LIFE_SATURATION = OnHitEffect.requireAspect(EnumAspect.LIFE, OnHitEffect.chanceWithCritMod(OnHitEffect.userPotionEffect(() -> new MobEffectInstance(MobEffects.SATURATION, 1, 1)).and(OnHitEffect.enemyPotionEffect(() -> new MobEffectInstance(MobEffects.HUNGER, 60, 100)))));
    public static final OnHitEffect BREATH_LEVITATION_AOE = OnHitEffect.requireAspect(EnumAspect.BREATH, OnHitEffect.chanceWithCritMod(OnHitEffect.potionAOE(() -> new MobEffectInstance(MobEffects.LEVITATION, 30, 2), () -> SoundEvents.ENDER_DRAGON_FLAP, 1.4f)));
    public static final OnHitEffect TIME_SLOWNESS_AOE = OnHitEffect.requireAspect(EnumAspect.TIME, OnHitEffect.chanceWithCritMod(OnHitEffect.potionAOE(() -> new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 4), () -> SoundEvents.BELL_RESONATE, 2.0f)));
    public static final OnHitEffect SET_CANDY_DROP_FLAG = (stack, target, attacker) -> {
        if (target instanceof UnderlingEntity) {
            ((UnderlingEntity)target).dropCandy = true;
        }
    };
    public static final OnHitEffect ICE_SHARD = (stack, target, attacker) -> {
        target.playSound(SoundEvents.GLASS_BREAK, 0.25f, 1.5f);
        if (!target.level().isClientSide && attacker instanceof Player) {
            Player player = (Player)attacker;
            if ((double)attacker.getRandom().nextFloat() < 0.1) {
                target.playSound(SoundEvents.GLASS_BREAK, 1.5f, 1.0f);
                target.hurt(player.damageSources().playerAttack(player), 2.0f);
                stack.hurtAndBreak(2, attacker, EquipmentSlot.MAINHAND);
                ItemEntity shardEntity = new ItemEntity(target.level(), target.getX(), target.getY(), target.getZ(), new ItemStack((ItemLike)MSItems.ICE_SHARD.get(), 1));
                target.level().addFreshEntity((Entity)shardEntity);
            }
        }
    };
    public static final OnHitEffect KUNDLER_SURPRISE = (stack, target, attacker) -> {
        ServerLevel serverWorld;
        LootTable lootTable;
        ObjectArrayList loot;
        if (!attacker.level().isClientSide && target.getHealth() <= 0.0f && (double)attacker.getRandom().nextFloat() <= 0.2 && !(loot = (lootTable = (serverWorld = (ServerLevel)target.level()).getServer().reloadableRegistries().getLootTable(MSLootTables.KUNDLER_SUPRISES)).getRandomItems(new LootParams.Builder(serverWorld).create(LootContextParamSets.EMPTY))).isEmpty()) {
            ItemEntity item = new ItemEntity(target.level(), target.getX(), target.getY(), target.getZ(), ((ItemStack)loot.get(0)).copy());
            target.level().addFreshEntity((Entity)item);
            attacker.sendSystemMessage((Component)Component.translatable((String)(stack.getDescriptionId() + ".message"), (Object[])new Object[]{((ItemStack)loot.get(0)).getHoverName()}).withStyle(ChatFormatting.GOLD));
        }
    };
    public static final OnHitEffect HORRORTERROR = (stack, target, attacker) -> {
        target.addEffect(new MobEffectInstance(MobEffects.WITHER, 100, 2));
        if (!attacker.level().isClientSide && attacker instanceof Player && (double)attacker.getRandom().nextFloat() < 0.1) {
            ImmutableList messages = ImmutableList.of((Object)"machinations", (Object)"stir", (Object)"suffering", (Object)"will", (Object)"done", (Object)"conspiracies", (Object)"waiting", (Object)"strife", (Object)"search", (Object)"blessings", (Object)"seek", (Object)"shadow", (Object[])new String[0]);
            String key = (String)messages.get(attacker.getRandom().nextInt(messages.size()));
            attacker.sendSystemMessage((Component)Component.translatable((String)("message.horrorterror." + key)).withStyle(ChatFormatting.DARK_PURPLE));
            boolean potionBool = attacker.getRandom().nextBoolean();
            if (potionBool) {
                attacker.addEffect(new MobEffectInstance(MobEffects.WITHER, 100, 2));
            } else {
                attacker.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 100, 0));
            }
        }
    };
    public static final OnHitEffect SPAWN_BREADCRUMBS = (stack, target, attacker) -> {
        if (!target.level().isClientSide) {
            ItemStack crumbs = new ItemStack((ItemLike)MSItems.BREADCRUMBS.get(), 1);
            ItemEntity item = new ItemEntity(target.level(), target.getX(), target.getY(), target.getZ(), crumbs);
            target.level().addFreshEntity((Entity)item);
        }
    };
    public static final OnHitEffect DROP_FOE_ITEM = (stack, target, attacker) -> {
        ItemStack heldByTarget = target.getMainHandItem();
        if (!target.level().isClientSide && !heldByTarget.isEmpty() && (double)attacker.getRandom().nextFloat() < 0.05) {
            ItemEntity item = new ItemEntity(target.level(), target.getX(), target.getY(), target.getZ(), heldByTarget.copy());
            item.getItem().setCount(1);
            item.setPickUpDelay(40);
            target.level().addFreshEntity((Entity)item);
            heldByTarget.shrink(1);
        }
    };
    public static final String SORD_DROP_MESSAGE = "drop_message";
    public static final OnHitEffect SORD_DROP = (stack, target, attacker) -> {
        if (!attacker.getCommandSenderWorld().isClientSide && (double)attacker.getRandom().nextFloat() < 0.25) {
            ItemEntity sord = new ItemEntity(attacker.level(), attacker.getX(), attacker.getY(), attacker.getZ(), stack.copy());
            sord.getItem().setCount(1);
            sord.setPickUpDelay(40);
            attacker.level().addFreshEntity((Entity)sord);
            stack.shrink(1);
            attacker.sendSystemMessage((Component)Component.translatable((String)(sord.getItem().getDescriptionId() + ".drop_message")));
        }
    };
    public static final OnHitEffect RANDOM_DAMAGE = (stack, target, attacker) -> {
        DamageSource source;
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            source = attacker.damageSources().playerAttack(player);
        } else {
            source = attacker.damageSources().mobAttack(attacker);
        }
        float rng = (float)(attacker.getRandom().nextInt(7) + 1) * (float)(attacker.getRandom().nextInt(7) + 1);
        target.hurt(source, rng);
    };
    public static final OnHitEffect SWEEP = (stack, target, attacker) -> {
        if (attacker instanceof Player) {
            Player playerAttacker = (Player)attacker;
            boolean slowMoving = (double)(playerAttacker.walkDist - playerAttacker.walkDistO) < (double)playerAttacker.getSpeed();
            boolean lastHitWasCrit = ServerEventHandler.wasLastHitCrit((LivingEntity)playerAttacker);
            if (slowMoving && !lastHitWasCrit && playerAttacker.onGround()) {
                float attackDamage = (float)playerAttacker.getAttributeValue(Attributes.ATTACK_DAMAGE);
                float sweepEnchantMod = 1.0f + (float)playerAttacker.getAttributeValue(Attributes.SWEEPING_DAMAGE_RATIO) * attackDamage;
                for (LivingEntity livingEntity : playerAttacker.level().getEntitiesOfClass(LivingEntity.class, target.getBoundingBox().inflate(1.0, 0.25, 1.0))) {
                    if (livingEntity == playerAttacker || livingEntity == target || playerAttacker.isAlliedTo((Entity)livingEntity) || livingEntity instanceof ArmorStand && ((ArmorStand)livingEntity).isMarker() || !(playerAttacker.distanceToSqr((Entity)livingEntity) < 9.0)) continue;
                    livingEntity.knockback((double)0.4f, (double)Mth.sin((float)(playerAttacker.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(playerAttacker.getYRot() * ((float)Math.PI / 180)))));
                    livingEntity.hurt(attacker.damageSources().playerAttack(playerAttacker), sweepEnchantMod);
                }
                playerAttacker.level().playSound(null, playerAttacker.getX(), playerAttacker.getY(), playerAttacker.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, playerAttacker.getSoundSource(), 1.0f, 1.0f);
                playerAttacker.sweepAttack();
            }
        }
    };
    public static final OnHitEffect SPREADING_KNOCKBACK = (stack, target, attacker) -> {
        double attackerRadians = Math.toRadians(attacker.getYRot()) - 1.5707963267948966;
        Vec3 attackerRight = new Vec3(Math.cos(attackerRadians), 0.0, Math.sin(attackerRadians));
        Vec3 dirToTarget = attacker.position().vectorTo(target.position()).multiply(1.0, 0.0, 1.0).normalize();
        double dot = attackerRight.dot(dirToTarget);
        double dotFactor = (double)Mth.sign((double)dot) * 1.5 * Math.pow(1.0 - Math.abs(dot), 0.3);
        Vec3 knockback = dirToTarget.scale(-1.0).add(attackerRight.scale(dotFactor)).normalize();
        target.knockback((double)0.7f, knockback.x, knockback.z);
    };
    public static final OnHitEffect SPACE_TELEPORT = OnHitEffect.withoutCreativeShock(OnHitEffect.requireAspect(EnumAspect.SPACE, OnHitEffect.onCrit((stack, target, attacker) -> {
        double oldPosX = attacker.getX();
        double oldPosY = attacker.getY();
        double oldPosZ = attacker.getZ();
        Level level = attacker.level();
        for (int i = 0; i < 16; ++i) {
            double newPosX = attacker.getX() + (attacker.getRandom().nextDouble() - 0.5) * 16.0;
            double newPosY = Mth.clamp((double)(attacker.getY() + (double)(attacker.getRandom().nextInt(16) - 8)), (double)0.0, (double)(level.getHeight() - 1));
            double newPosZ = attacker.getZ() + (attacker.getRandom().nextDouble() - 0.5) * 16.0;
            if (attacker.isPassenger()) {
                attacker.stopRiding();
            }
            if (!attacker.randomTeleport(newPosX, newPosY, newPosZ, true)) continue;
            level.playSound(null, oldPosX, oldPosY, oldPosZ, SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
            attacker.playSound(SoundEvents.CHORUS_FRUIT_TELEPORT, 1.0f, 1.0f);
            attacker.lookAt(attacker.createCommandSourceStack().getAnchor(), target.position());
            break;
        }
    })));
    public static final OnHitEffect BOSS_BUSTER = (stack, target, attacker) -> {
        if (attacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)attacker;
            if (target.getType().is(MSTags.EntityTypes.BOSS_MOB)) {
                target.hurt(target.damageSources().playerAttack((Player)player), target.getMaxHealth() / 20.0f);
            }
        }
    };

    public void onHit(ItemStack var1, LivingEntity var2, LivingEntity var3);

    public static OnHitEffect setOnFire(int duration) {
        return (itemStack, target, attacker) -> target.igniteForSeconds((float)duration);
    }

    public static OnHitEffect armorBypassingDamageMod(float additionalDamage, EnumAspect aspect) {
        return (stack, target, attacker) -> {
            float damage = additionalDamage * 3.3f;
            if (attacker instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)attacker;
                if (!(attacker instanceof FakePlayer)) {
                    boolean isMissingAspectBonus;
                    boolean bl = isMissingAspectBonus = !Title.isPlayerOfAspect(serverPlayer, aspect);
                    if (target instanceof UnderlingEntity) {
                        float modifier = (float)serverPlayer.getAttributeValue(MSAttributes.UNDERLING_DAMAGE_MODIFIER);
                        if (isMissingAspectBonus) {
                            modifier /= 1.2f;
                        }
                        damage *= modifier;
                    } else if (isMissingAspectBonus) {
                        damage /= 1.2f;
                    }
                }
            }
            target.hurt(MSDamageSources.armorPierce(attacker.level().registryAccess(), (Entity)attacker), damage);
        };
    }

    public static OnHitEffect backstab(float backstabDamage) {
        return (stack, target, attacker) -> {
            Direction direction = target.getDirection().getOpposite();
            BlockPos targetBack = target.blockPosition().relative(direction, 3);
            if (targetBack.closerThan((Vec3i)attacker.blockPosition(), 3.0)) {
                DamageSource source;
                for (int i = 0; i < 4; ++i) {
                    target.level().addParticle((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, true, (double)target.blockPosition().relative(direction).getX(), target.getEyePosition((float)1.0f).y - 1.0, (double)target.blockPosition().relative(direction).getZ(), 0.1, 0.1, 0.1);
                }
                if (attacker instanceof Player) {
                    Player player = (Player)attacker;
                    source = target.damageSources().playerAttack(player);
                } else {
                    source = target.damageSources().mobAttack(attacker);
                }
                target.hurt(source, backstabDamage);
            }
        };
    }

    public static OnHitEffect targetSpecificAdditionalDamage(float additionalDamage, Supplier<? extends EntityType<?>> targetEntity) {
        return (stack, target, attacker) -> {
            float damage = additionalDamage * 3.3f;
            if (attacker instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)attacker;
                if (target.getType() == targetEntity.get()) {
                    target.hurt(target.damageSources().playerAttack((Player)serverPlayer), damage);
                }
            }
        };
    }

    public static OnHitEffect playSound(Supplier<SoundEvent> sound) {
        return OnHitEffect.playSound(sound, 1.0f, 1.0f);
    }

    public static OnHitEffect playSound(Supplier<SoundEvent> sound, float volume, float pitch) {
        return (itemStack, target, attacker) -> attacker.level().playSound(null, attacker.getX(), attacker.getY(), attacker.getZ(), (SoundEvent)sound.get(), attacker.getSoundSource(), volume, pitch);
    }

    public static OnHitEffect enemyKnockback(float knockback) {
        return (stack, target, attacker) -> {
            float randFloat = knockback + attacker.getRandom().nextFloat();
            if (!attacker.getCommandSenderWorld().isClientSide) {
                target.setDeltaMovement(target.getDeltaMovement().x * (double)randFloat, target.getDeltaMovement().y, target.getDeltaMovement().z * (double)randFloat);
            }
        };
    }

    public static OnHitEffect mutualKnockback(float knockback) {
        return (itemStack, target, attacker) -> {
            Vec3 targetVec = attacker.getLookAngle().scale((double)(1.0f + knockback));
            Vec3 attackerVec = targetVec.reverse();
            target.push(targetVec.x, targetVec.y, targetVec.z);
            if (attacker.getVehicle() != null) {
                attacker.dismountTo(attacker.getX(), attacker.getY(), attacker.getZ());
            }
            attacker.push(attackerVec.x, attackerVec.y, attackerVec.z);
            if (attacker instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)attacker;
                PushPlayerPacket packet = PushPlayerPacket.createPacket(attackerVec);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        };
    }

    public static OnHitEffect userPotionEffect(Supplier<MobEffectInstance> effect) {
        return (stack, target, attacker) -> attacker.addEffect((MobEffectInstance)effect.get());
    }

    public static OnHitEffect enemyPotionEffect(Supplier<MobEffectInstance> effect) {
        return (stack, target, attacker) -> target.addEffect((MobEffectInstance)effect.get());
    }

    public static OnHitEffect sweepMultiEffect(OnHitEffect ... effects) {
        return (stack, target, attacker) -> {
            if (!(attacker instanceof Player)) {
                return;
            }
            Player playerAttacker = (Player)attacker;
            boolean slowMoving = (double)(playerAttacker.walkDist - playerAttacker.walkDistO) < (double)playerAttacker.getSpeed();
            boolean lastHitWasCrit = ServerEventHandler.wasLastHitCrit((LivingEntity)playerAttacker);
            if (!slowMoving || lastHitWasCrit || !playerAttacker.onGround() || playerAttacker.getAttackStrengthScale(0.0f) < 1.0f) {
                return;
            }
            float attackDamage = (float)playerAttacker.getAttributeValue(Attributes.ATTACK_DAMAGE);
            float sweepEnchantMod = 1.0f + (float)playerAttacker.getAttributeValue(Attributes.SWEEPING_DAMAGE_RATIO) * attackDamage;
            for (LivingEntity livingEntity : playerAttacker.level().getEntitiesOfClass(LivingEntity.class, target.getBoundingBox().inflate(2.0, 0.25, 2.0))) {
                ArmorStand armorStand;
                if (livingEntity == playerAttacker || playerAttacker.isAlliedTo((Entity)livingEntity) || playerAttacker.distanceToSqr((Entity)livingEntity) >= 9.0 || livingEntity instanceof ArmorStand && (armorStand = (ArmorStand)livingEntity).isMarker()) continue;
                if (livingEntity != target) {
                    livingEntity.hurt(target.damageSources().playerAttack(playerAttacker), sweepEnchantMod);
                }
                for (OnHitEffect effect : effects) {
                    effect.onHit(stack, livingEntity, attacker);
                }
            }
            playerAttacker.level().playSound(null, playerAttacker.getX(), playerAttacker.getY(), playerAttacker.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, playerAttacker.getSoundSource(), 1.0f, 1.0f);
            playerAttacker.sweepAttack();
        };
    }

    public static OnHitEffect spawnParticles(SimpleParticleType particle, int amount, double xMovement, double yMovement, double zMovement, double speed) {
        return (stack, target, attacker) -> {
            Level level = target.level();
            if (!level.isClientSide) {
                ((ServerLevel)level).sendParticles((ParticleOptions)particle, target.getX(), target.getY(), target.getZ(), amount, xMovement, yMovement, zMovement, speed);
            }
        };
    }

    public static OnHitEffect requireAspect(EnumAspect aspect, OnHitEffect effect) {
        return (stack, target, attacker) -> {
            ServerPlayer player;
            if (attacker instanceof ServerPlayer && ((player = (ServerPlayer)attacker).isCreative() || Title.isPlayerOfAspect(player, aspect))) {
                effect.onHit(stack, target, attacker);
            }
        };
    }

    public static OnHitEffect withoutCreativeShock(OnHitEffect effect) {
        return (stack, target, attacker) -> {
            Player player;
            if (!(attacker instanceof Player) || !CreativeShockEffect.doesCreativeShockLimit(player = (Player)attacker, 2)) {
                effect.onHit(stack, target, attacker);
            }
        };
    }

    public static OnHitEffect onCrit(OnHitEffect effect) {
        return (stack, target, attacker) -> {
            if (ServerEventHandler.wasLastHitCrit(attacker)) {
                effect.onHit(stack, target, attacker);
            }
        };
    }

    public static OnHitEffect chanceWithCritMod(OnHitEffect effect) {
        return (stack, target, attacker) -> {
            if (!attacker.level().isClientSide) {
                double d = attacker.getRandom().nextFloat();
                double d2 = ServerEventHandler.wasLastHitCrit(attacker) ? 0.2 : 0.1;
                if (d < d2) {
                    effect.onHit(stack, target, attacker);
                }
            }
        };
    }

    public static OnHitEffect notAtPlayer(OnHitEffect effect) {
        return (stack, target, attacker) -> {
            if (!(target instanceof Player)) {
                effect.onHit(stack, target, attacker);
            }
        };
    }

    public static OnHitEffect potionAOE(Supplier<MobEffectInstance> effect, Supplier<SoundEvent> sound, float pitch) {
        return (stack, target, attacker) -> {
            AABB axisalignedbb = attacker.getBoundingBox().inflate(4.0, 2.0, 4.0);
            List list = attacker.level().getEntitiesOfClass(LivingEntity.class, axisalignedbb);
            list.remove(attacker);
            if (!list.isEmpty()) {
                attacker.level().playSound(null, attacker.blockPosition(), (SoundEvent)sound.get(), SoundSource.PLAYERS, 1.5f, pitch);
                for (LivingEntity livingentity : list) {
                    livingentity.addEffect((MobEffectInstance)effect.get());
                }
            }
        };
    }

    default public OnHitEffect and(OnHitEffect effect) {
        return (stack, target, attacker) -> {
            this.onHit(stack, target, attacker);
            effect.onHit(stack, target, attacker);
        };
    }
}

