/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.weapon;

import com.mraof.minestuck.effects.CreativeShockEffect;
import com.mraof.minestuck.item.weapon.ItemRightClickEffect;
import com.mraof.minestuck.item.weapon.OnHitEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PogoEffect
implements ItemRightClickEffect,
OnHitEffect {
    public static final PogoEffect EFFECT_02 = new PogoEffect(0.2);
    public static final PogoEffect EFFECT_04 = new PogoEffect(0.4);
    public static final PogoEffect EFFECT_05 = new PogoEffect(0.5);
    public static final PogoEffect EFFECT_06 = new PogoEffect(0.6);
    public static final PogoEffect EFFECT_07 = new PogoEffect(0.7);
    private final double pogoMotion;

    public PogoEffect(double pogoMotion) {
        this.pogoMotion = pogoMotion;
    }

    @Override
    public void onHit(ItemStack stack, LivingEntity target, LivingEntity player) {
        PogoEffect.hitEntity(stack, target, player, this.getPogoMotion(stack));
    }

    private double getPogoMotion(ItemStack stack) {
        return this.pogoMotion;
    }

    private static double addEfficiencyModifier(double pogoMotion, ItemStack stack, HolderLookup.Provider registries) {
        Holder.Reference efficiency = registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.EFFICIENCY);
        return pogoMotion * ((double)stack.getEnchantmentLevel((Holder)efficiency) * 0.15 + 1.0);
    }

    @Override
    public InteractionResultHolder<ItemStack> onRightClick(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        BlockHitResult blockraytraceresult = PogoEffect.getPlayerPOVHitResult(level, player);
        if (blockraytraceresult.getType() == HitResult.Type.BLOCK) {
            return PogoEffect.onItemUse(player, level, blockraytraceresult.getBlockPos(), stack, blockraytraceresult.getDirection(), this.getPogoMotion(stack)) == InteractionResult.SUCCESS ? InteractionResultHolder.success((Object)stack) : InteractionResultHolder.pass((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    private static BlockHitResult getPlayerPOVHitResult(Level level, Player playerEntity) {
        float xRot = playerEntity.getXRot();
        float yRot = playerEntity.getYRot();
        Vec3 eyeVec = playerEntity.getEyePosition(1.0f);
        float f2 = Mth.cos((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-xRot * ((float)Math.PI / 180)));
        float yComponent = Mth.sin((float)(-xRot * ((float)Math.PI / 180)));
        float xComponent = f3 * f4;
        float zComponent = f2 * f4;
        double reachDistance = playerEntity.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
        Vec3 endVec = eyeVec.add((double)xComponent * reachDistance, (double)yComponent * reachDistance, (double)zComponent * reachDistance);
        return level.clip(new ClipContext(eyeVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)playerEntity));
    }

    private static void hitEntity(ItemStack stack, LivingEntity target, LivingEntity player, double pogoMotion) {
        pogoMotion = PogoEffect.addEfficiencyModifier(pogoMotion, stack, (HolderLookup.Provider)player.registryAccess());
        if (!(!(player.fallDistance > 0.0f) || player.onGround() || player.onClimbable() || player.isInWater() || player.isPassenger())) {
            double knockbackModifier = 1.0 - target.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
            double targetMotionY = Math.max(target.getDeltaMovement().y, knockbackModifier * Math.min(pogoMotion * 2.0, Math.abs(player.getDeltaMovement().y) + target.getDeltaMovement().y + pogoMotion));
            target.setDeltaMovement(target.getDeltaMovement().x, targetMotionY, target.getDeltaMovement().z);
            player.setDeltaMovement(player.getDeltaMovement().x, 0.0, player.getDeltaMovement().z);
            player.fallDistance = 0.0f;
        }
    }

    private static InteractionResult onItemUse(Player player, Level level, BlockPos pos, ItemStack stack, Direction facing, double pogoMotion) {
        pogoMotion = PogoEffect.addEfficiencyModifier(pogoMotion, stack, (HolderLookup.Provider)player.registryAccess());
        if (level.getBlockState(pos).getBlock() != Blocks.AIR && !CreativeShockEffect.doesCreativeShockLimit(player, 2)) {
            double velocity = Math.max(player.getDeltaMovement().y, Math.min(pogoMotion * 2.0, Math.abs(player.getDeltaMovement().y) + pogoMotion));
            float HORIZONTAL_Y = 6.0f;
            switch (facing.getAxis()) {
                case X: {
                    double playerMotionX = (velocity += Math.abs(player.getDeltaMovement().x) / 2.0) * (double)facing.getNormal().getX();
                    double playerMotionY = velocity / 6.0;
                    player.setDeltaMovement(playerMotionX, playerMotionY, player.getDeltaMovement().z);
                    break;
                }
                case Y: {
                    double playerMotionY = velocity * (double)facing.getNormal().getY();
                    player.setDeltaMovement(player.getDeltaMovement().x, playerMotionY, player.getDeltaMovement().z);
                    break;
                }
                case Z: {
                    double playerMotionY = (velocity += Math.abs(player.getDeltaMovement().z) / 2.0) / 6.0;
                    double playerMotionZ = velocity * (double)facing.getNormal().getZ();
                    player.setDeltaMovement(player.getDeltaMovement().x, playerMotionY, playerMotionZ);
                }
            }
            player.fallDistance = 0.0f;
            stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

