/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.weapon;

import com.mraof.minestuck.effects.CreativeShockEffect;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public interface RightClickBlockEffect {
    public InteractionResult onClick(UseOnContext var1);

    public static RightClickBlockEffect placeFluid(Supplier<Block> fluidBlock, Holder<Item> otherItem) {
        return RightClickBlockEffect.withoutCreativeShock(context -> {
            Level level = context.getLevel();
            Player player = context.getPlayer();
            ItemStack itemStack = context.getItemInHand();
            Direction facing = context.getClickedFace();
            BlockPos pos = context.getClickedPos().relative(facing);
            BlockState state = level.getBlockState(pos);
            if (state.getBlock() == Blocks.AIR || state.getBlock() == fluidBlock.get()) {
                if (!level.isClientSide && player != null) {
                    level.setBlockAndUpdate(pos, ((Block)fluidBlock.get()).defaultBlockState());
                    ItemStack newItem = new ItemStack(otherItem, itemStack.getCount(), itemStack.getComponentsPatch());
                    player.setItemInHand(context.getHand(), newItem);
                    level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 2.0f);
                    player.getCooldowns().addCooldown((Item)otherItem.value(), 5);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        });
    }

    public static RightClickBlockEffect scoopBlock(Supplier<Block> validBlock) {
        return RightClickBlockEffect.withoutCreativeShock(context -> {
            Level level = context.getLevel();
            BlockPos pos = context.getClickedPos();
            Player player = context.getPlayer();
            Direction facing = context.getClickedFace();
            boolean inside = context.isInside();
            BlockState state = level.getBlockState(pos);
            BlockHitResult blockRayTrace = new BlockHitResult(context.getClickLocation(), facing, pos, inside);
            Item lookedAtBlockItem = state.getCloneItemStack((HitResult)blockRayTrace, (LevelReader)level, pos, player).getItem();
            if (player != null && state.getBlock() == validBlock.get()) {
                if (!level.isClientSide) {
                    if (!player.getInventory().add(new ItemStack((ItemLike)lookedAtBlockItem))) {
                        player.drop(new ItemStack((ItemLike)lookedAtBlockItem), false);
                    }
                    context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                    level.setBlockAndUpdate(blockRayTrace.getBlockPos(), Blocks.AIR.defaultBlockState());
                }
                level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.NEUTRAL, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        });
    }

    public static RightClickBlockEffect withoutCreativeShock(RightClickBlockEffect effect) {
        return context -> {
            Player player = context.getPlayer();
            if (player != null && !CreativeShockEffect.doesCreativeShockLimit(player, 0)) {
                return effect.onClick(context);
            }
            return InteractionResult.PASS;
        };
    }
}

