/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.weapon;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.mraof.minestuck.item.weapon.DestroyBlockEffect;
import com.mraof.minestuck.item.weapon.FinishUseItemEffect;
import com.mraof.minestuck.item.weapon.InventoryTickEffect;
import com.mraof.minestuck.item.weapon.ItemRightClickEffect;
import com.mraof.minestuck.item.weapon.MSToolType;
import com.mraof.minestuck.item.weapon.OnHitEffect;
import com.mraof.minestuck.item.weapon.RightClickBlockEffect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbility;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class WeaponItem
extends TieredItem {
    private final float efficiency;
    private final boolean disableShield;
    @Nullable
    private final List<MSToolType> toolTypes;
    private final Set<ItemAbility> toolActions;
    private final List<OnHitEffect> onHitEffects;
    @Nullable
    private final DestroyBlockEffect destroyBlockEffect;
    @Nullable
    private final RightClickBlockEffect rightClickBlockEffect;
    @Nullable
    private final ItemRightClickEffect itemRightClickEffect;
    private final int useDuration;
    private final UseAnim useAction;
    private final List<FinishUseItemEffect> itemUsageEffects;
    private final List<InventoryTickEffect> tickEffects;

    public WeaponItem(Builder builder, Item.Properties properties) {
        super(builder.tier, builder.updateProperties(properties));
        this.toolTypes = builder.toolType;
        this.toolActions = builder.toolActions;
        this.efficiency = builder.efficiency;
        this.disableShield = builder.disableShield;
        this.onHitEffects = ImmutableList.copyOf(builder.onHitEffects);
        this.destroyBlockEffect = builder.destroyBlockEffect;
        this.rightClickBlockEffect = builder.rightClickBlockEffect;
        this.itemRightClickEffect = builder.itemRightClickEffect;
        this.useDuration = builder.useDuration;
        this.useAction = builder.useAction;
        this.itemUsageEffects = ImmutableList.copyOf(builder.itemUsageEffects);
        this.tickEffects = ImmutableList.copyOf(builder.tickEffects);
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (this.destroyBlockEffect != null) {
            this.destroyBlockEffect.onDestroyBlock(stack, level, state, pos, entityLiving);
        }
        return super.mineBlock(stack, level, state, pos, entityLiving);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility toolAction) {
        return this.toolActions.contains(toolAction);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (this.rightClickBlockEffect != null) {
            return this.rightClickBlockEffect.onClick(context);
        }
        return super.useOn(context);
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return this.disableShield;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        if (this.itemRightClickEffect != null) {
            return this.itemRightClickEffect.onRightClick(level, playerIn, handIn);
        }
        return super.use(level, playerIn, handIn);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return this.useAction;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entityLiving) {
        for (FinishUseItemEffect effect : this.itemUsageEffects) {
            stack = effect.onItemUseFinish(stack, level, entityLiving);
        }
        return super.finishUsingItem(stack, level, entityLiving);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entityIn, int itemSlot, boolean isSelected) {
        for (InventoryTickEffect effect : this.tickEffects) {
            effect.inventoryTick(stack, level, entityIn, itemSlot, isSelected);
        }
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        this.onHitEffects.forEach(effect -> effect.onHit(stack, target, attacker));
        return true;
    }

    @Nullable
    public List<MSToolType> getToolTypes() {
        return this.toolTypes;
    }

    public float getEfficiency() {
        return this.efficiency;
    }

    public ItemRightClickEffect getItemRightClickEffect() {
        return this.itemRightClickEffect;
    }

    private static Tool createToolProperties(Tier tier, List<TagKey<Block>> mineableBlocks, float efficiency) {
        return new Tool(Streams.concat((Stream[])new Stream[]{mineableBlocks.stream().map(tag -> Tool.Rule.minesAndDrops((TagKey)tag, (float)efficiency)), Stream.of(Tool.Rule.deniesDrops((TagKey)tier.getIncorrectBlocksForDrops()))}).toList(), 1.0f, 1);
    }

    public static class Builder {
        private final Tier tier;
        private final int attackDamage;
        private final float attackSpeed;
        private List<MSToolType> toolType = List.of();
        private final Set<ItemAbility> toolActions = new HashSet<ItemAbility>();
        private float efficiency;
        private boolean disableShield;
        private final List<OnHitEffect> onHitEffects = new ArrayList<OnHitEffect>();
        @Nullable
        private DestroyBlockEffect destroyBlockEffect = null;
        @Nullable
        private RightClickBlockEffect rightClickBlockEffect = null;
        @Nullable
        private ItemRightClickEffect itemRightClickEffect;
        private int useDuration = 0;
        private UseAnim useAction = UseAnim.NONE;
        private final List<FinishUseItemEffect> itemUsageEffects = new ArrayList<FinishUseItemEffect>();
        private final List<InventoryTickEffect> tickEffects = new ArrayList<InventoryTickEffect>();

        public Builder(Tier tier, int attackDamage, float attackSpeed) {
            this.tier = tier;
            this.attackDamage = attackDamage;
            this.attackSpeed = attackSpeed;
            this.efficiency = tier.getSpeed();
        }

        public Builder set(MSToolType ... toolTypes) {
            this.toolType = List.of(toolTypes);
            for (MSToolType toolType : this.toolType) {
                this.toolActions.addAll(List.of(toolType.abilities()));
            }
            return this;
        }

        public Builder set(DestroyBlockEffect effect) {
            if (this.destroyBlockEffect != null) {
                throw new IllegalStateException("Destroy block effect has already been set");
            }
            this.destroyBlockEffect = effect;
            return this;
        }

        public Builder set(RightClickBlockEffect effect) {
            if (this.rightClickBlockEffect != null) {
                throw new IllegalStateException("Right click block effect has already been set");
            }
            this.rightClickBlockEffect = effect;
            return this;
        }

        public Builder set(ItemRightClickEffect effect) {
            if (this.itemRightClickEffect != null) {
                throw new IllegalStateException("Item right click effect has already been set");
            }
            this.itemRightClickEffect = effect;
            return this;
        }

        public Builder efficiency(float efficiency) {
            this.efficiency = efficiency;
            return this;
        }

        public Builder disableShield() {
            this.disableShield = true;
            return this;
        }

        public Builder add(OnHitEffect ... effects) {
            this.onHitEffects.addAll(Arrays.asList(effects));
            return this;
        }

        public Builder add(InventoryTickEffect ... effects) {
            this.tickEffects.addAll(Arrays.asList(effects));
            return this;
        }

        public Builder add(ItemAbility ... actions) {
            this.toolActions.addAll(List.of(actions));
            return this;
        }

        public Builder setEating(FinishUseItemEffect ... effects) {
            return this.addItemUses(32, UseAnim.EAT, effects);
        }

        public Builder setEating(int duration, FinishUseItemEffect ... effects) {
            return this.addItemUses(duration, UseAnim.EAT, effects);
        }

        public Builder addItemUses(int duration, UseAnim action, FinishUseItemEffect ... effects) {
            this.useDuration = duration;
            this.useAction = action;
            this.itemUsageEffects.addAll(Arrays.asList(effects));
            this.set(ItemRightClickEffect.ACTIVE_HAND);
            return this;
        }

        private Item.Properties updateProperties(Item.Properties properties) {
            properties.attributes(DiggerItem.createAttributes((Tier)this.tier, (float)this.attackDamage, (float)this.attackSpeed));
            ArrayList<TagKey<Block>> mineableBlocks = new ArrayList<TagKey<Block>>();
            for (MSToolType toolType : this.toolType) {
                if (toolType.mineableBlocks() == null) continue;
                mineableBlocks.add(toolType.mineableBlocks());
            }
            if (!mineableBlocks.isEmpty()) {
                properties.component(DataComponents.TOOL, (Object)WeaponItem.createToolProperties(this.tier, mineableBlocks, this.efficiency));
            }
            return properties;
        }
    }
}

