/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.weapon.projectiles;

import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.entity.item.ConsumableProjectileEntity;
import com.mraof.minestuck.item.weapon.projectiles.ProjectileDamaging;
import com.mraof.minestuck.util.MSSoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ConsumableProjectileWeaponItem
extends Item
implements ProjectileDamaging {
    public final float velocity;
    public final float accuracy;
    public final int damage;

    public ConsumableProjectileWeaponItem(Item.Properties properties, float velocity, float accuracy, int damage) {
        super(properties);
        this.velocity = velocity;
        this.accuracy = accuracy;
        this.damage = damage;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack item = playerIn.getItemInHand(handIn);
        level.playSound(null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), MSSoundEvents.ITEM_PROJECTILE_THROW.get(), SoundSource.PLAYERS, 0.8f, 1.5f);
        if (!level.isClientSide) {
            ConsumableProjectileEntity projectileEntity = new ConsumableProjectileEntity(MSEntityTypes.CONSUMABLE_PROJECTILE.get(), (LivingEntity)playerIn, level);
            projectileEntity.setItem(item);
            projectileEntity.shootFromRotation((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), 0.0f, this.velocity, this.accuracy);
            level.addFreshEntity((Entity)projectileEntity);
        }
        if (!playerIn.isCreative()) {
            item.shrink(1);
        }
        playerIn.getCooldowns().addCooldown((Item)this, 7);
        playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.success((Object)item);
    }

    @Override
    public int getProjectileDamage() {
        return this.damage;
    }
}

