/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.item.weapon.projectiles;

import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.entity.item.ReturningProjectileEntity;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.weapon.projectiles.ConsumableProjectileWeaponItem;
import com.mraof.minestuck.player.EnumAspect;
import com.mraof.minestuck.player.Title;
import com.mraof.minestuck.util.MSSoundEvents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ReturningProjectileWeaponItem
extends ConsumableProjectileWeaponItem {
    protected final int maxTick;

    public ReturningProjectileWeaponItem(Item.Properties properties, float velocity, float accuracy, int damage, int maxTick) {
        super(properties, velocity, accuracy, damage);
        this.maxTick = maxTick;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack item = playerIn.getItemInHand(handIn);
        level.playSound(null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), MSSoundEvents.ITEM_PROJECTILE_THROW.get(), SoundSource.PLAYERS, 1.0f, 1.2f);
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            boolean noBlockCollision = item.is(MSItems.UMBRAL_INFILTRATOR) && (playerIn.isCreative() || Title.isPlayerOfAspect(serverPlayer, EnumAspect.VOID));
            ReturningProjectileEntity projectileEntity = new ReturningProjectileEntity(MSEntityTypes.RETURNING_PROJECTILE.get(), (LivingEntity)playerIn, level, this.maxTick, noBlockCollision);
            projectileEntity.setItem(item);
            projectileEntity.shootFromRotation((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), 0.0f, this.velocity, this.accuracy);
            projectileEntity.setNoGravity(true);
            if (noBlockCollision) {
                projectileEntity.setGlowingTag(true);
            }
            level.addFreshEntity((Entity)projectileEntity);
        }
        item.hurtAndBreak(1, (LivingEntity)playerIn, EquipmentSlot.MAINHAND);
        playerIn.getCooldowns().addCooldown((Item)this, this.maxTick);
        playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.success((Object)item);
    }
}

