/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.jei;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.api.alchemy.recipe.combination.JeiCombination;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.item.CaptchaCardItem;
import com.mraof.minestuck.jei.MinestuckJeiPlugin;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DesignixRecipeCategory
implements IRecipeCategory<JeiCombination> {
    private final IDrawable background;
    private final IDrawable icon;

    DesignixRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation punchDesignixBackground = Minestuck.id("textures/gui/designix.png");
        this.background = guiHelper.createDrawable(punchDesignixBackground, 43, 25, 94, 42);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MSBlocks.PUNCH_DESIGNIX));
    }

    public RecipeType<JeiCombination> getRecipeType() {
        return MinestuckJeiPlugin.DESIGNIX;
    }

    public Component getTitle() {
        return Component.translatable((String)((Block)MSBlocks.PUNCH_DESIGNIX.KEYBOARD.get()).getDescriptionId());
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, JeiCombination recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients(recipe.input1());
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 25).addIngredients(recipe.input2());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 73, 12).addItemStack(recipe.output())).addItemStack(CaptchaCardItem.createPunchedCard(recipe.output().getItem()));
    }
}

