/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.jei;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.api.alchemy.recipe.JeiGristCost;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.client.util.GuiUtil;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.components.EncodedItemComponent;
import com.mraof.minestuck.jei.MinestuckJeiPlugin;
import com.mraof.minestuck.player.ClientPlayerData;
import com.mraof.minestuck.util.ColorHandler;
import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GristCostRecipeCategory
implements IRecipeCategory<JeiGristCost> {
    private final IDrawable background;
    private final IDrawable icon;

    GristCostRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation alchemiterBackground = Minestuck.id("textures/gui/alchemiter.png");
        this.background = guiHelper.createDrawable(alchemiterBackground, 8, 15, 160, 56);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MSBlocks.ALCHEMITER));
    }

    public RecipeType<JeiGristCost> getRecipeType() {
        return MinestuckJeiPlugin.GRIST_COST;
    }

    public Component getTitle() {
        return Component.translatable((String)"minestuck.jei.grist_costs");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, JeiGristCost recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.CATALYST, 19, 5).addItemStacks(Arrays.stream(recipe.ingredient().getItems()).map(itemStack -> EncodedItemComponent.createEncoded(MSItems.CRUXITE_DOWEL, itemStack.getItem())).map(itemStack -> ColorHandler.setColor(itemStack, ClientPlayerData.getPlayerColor())).toList());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 127, 5).addIngredients(recipe.ingredient());
        if (recipe instanceof JeiGristCost.Set) {
            JeiGristCost.Set gristSetRecipe = (JeiGristCost.Set)recipe;
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addIngredients(MinestuckJeiPlugin.GRIST, gristSetRecipe.gristSet().asAmounts());
        }
    }

    public void draw(JeiGristCost recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (recipe instanceof JeiGristCost.Set) {
            JeiGristCost.Set gristSetRecipe = (JeiGristCost.Set)recipe;
            GuiUtil.drawGristBoard(guiGraphics, gristSetRecipe.gristSet(), GuiUtil.GristboardMode.ALCHEMITER, 1, 30, Minecraft.getInstance().font);
        } else if (recipe instanceof JeiGristCost.Wildcard) {
            JeiGristCost.Wildcard wildcardRecipe = (JeiGristCost.Wildcard)recipe;
            GuiUtil.drawGristBoard(guiGraphics, GristTypes.BUILD.get().amount(wildcardRecipe.wildcardAmount()), GuiUtil.GristboardMode.JEI_WILDCARD, 1, 30, Minecraft.getInstance().font);
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, JeiGristCost recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        Component text = null;
        if (recipe instanceof JeiGristCost.Set) {
            JeiGristCost.Set gristSetRecipe = (JeiGristCost.Set)recipe;
            text = GuiUtil.getGristboardTooltip(gristSetRecipe.gristSet(), GuiUtil.GristboardMode.ALCHEMITER, mouseX, mouseY, 1, 30, Minecraft.getInstance().font);
        } else if (recipe instanceof JeiGristCost.Wildcard) {
            JeiGristCost.Wildcard wildcardRecipe = (JeiGristCost.Wildcard)recipe;
            text = GuiUtil.getGristboardTooltip(GristTypes.BUILD.get().amount(wildcardRecipe.wildcardAmount()), GuiUtil.GristboardMode.JEI_WILDCARD, mouseX, mouseY, 1, 30, Minecraft.getInstance().font);
        }
        if (text != null) {
            tooltip.add(text);
        }
    }
}

