/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.jei;

import com.mraof.minestuck.api.alchemy.GristAmount;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.jei.MinestuckJeiPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GristIngredientHelper
implements IIngredientHelper<GristAmount> {
    public static List<GristAmount> createList() {
        ArrayList<GristAmount> list = new ArrayList<GristAmount>();
        for (GristType gristType : GristTypes.REGISTRY) {
            list.add(gristType.amount(1L));
        }
        return list;
    }

    public IIngredientType<GristAmount> getIngredientType() {
        return MinestuckJeiPlugin.GRIST;
    }

    public String getDisplayName(GristAmount ingredient) {
        return ingredient.type().getDisplayName().getString();
    }

    public String getUniqueId(GristAmount ingredient, UidContext context) {
        return "grist:" + String.valueOf(this.getResourceLocation(ingredient));
    }

    public Iterable<Integer> getColors(GristAmount ingredient) {
        return Collections.emptyList();
    }

    public ResourceLocation getResourceLocation(GristAmount ingredient) {
        return ingredient.type().getIdOrThrow();
    }

    public GristAmount copyIngredient(GristAmount ingredient) {
        return new GristAmount(ingredient.type(), ingredient.amount());
    }

    public String getErrorInfo(@Nullable GristAmount ingredient) {
        if (ingredient == null) {
            return "grist:null";
        }
        if (ingredient.type() == null) {
            return "grist:null:" + ingredient.amount();
        }
        return "grist:" + String.valueOf(this.getResourceLocation(ingredient)) + ":" + ingredient.amount();
    }
}

