/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mraof.minestuck.api.alchemy.GristAmount;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;
import org.joml.Matrix4f;

public class GristIngredientRenderer
implements IIngredientRenderer<GristAmount> {
    public void render(GuiGraphics guiGraphics, @Nullable GristAmount ingredient) {
        if (ingredient == null) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ingredient.type().getIcon());
        Matrix4f pose = guiGraphics.pose().last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(pose, 0.0f, 16.0f, 0.0f).setUv(0.0f, 1.0f);
        buffer.addVertex(pose, 16.0f, 16.0f, 0.0f).setUv(1.0f, 1.0f);
        buffer.addVertex(pose, 16.0f, 0.0f, 0.0f).setUv(1.0f, 0.0f);
        buffer.addVertex(pose, 0.0f, 0.0f, 0.0f).setUv(0.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public List<Component> getTooltip(GristAmount ingredient, TooltipFlag tooltipFlag) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)ingredient.type().getDisplayName());
        list.add((Component)Component.literal((String)String.valueOf(ingredient.type())).withStyle(ChatFormatting.DARK_GRAY));
        return list;
    }
}

