/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.jei;

import com.mraof.minestuck.api.alchemy.GristAmount;
import com.mraof.minestuck.api.alchemy.recipe.GristCostRecipe;
import com.mraof.minestuck.api.alchemy.recipe.JeiGristCost;
import com.mraof.minestuck.api.alchemy.recipe.combination.CombinationMode;
import com.mraof.minestuck.api.alchemy.recipe.combination.CombinationRecipe;
import com.mraof.minestuck.api.alchemy.recipe.combination.JeiCombination;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.crafting.MSRecipeTypes;
import com.mraof.minestuck.jei.DesignixRecipeCategory;
import com.mraof.minestuck.jei.GristCostRecipeCategory;
import com.mraof.minestuck.jei.GristIngredientHelper;
import com.mraof.minestuck.jei.GristIngredientRenderer;
import com.mraof.minestuck.jei.TotemLatheRecipeCategory;
import java.util.Objects;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@JeiPlugin
public class MinestuckJeiPlugin
implements IModPlugin {
    public static final RecipeType<JeiGristCost> GRIST_COST = RecipeType.create((String)"minestuck", (String)"grist_cost", JeiGristCost.class);
    public static final RecipeType<JeiCombination> LATHE = RecipeType.create((String)"minestuck", (String)"totem_lathe", JeiCombination.class);
    public static final RecipeType<JeiCombination> DESIGNIX = RecipeType.create((String)"minestuck", (String)"punch_designix", JeiCombination.class);
    public static final IIngredientType<GristAmount> GRIST = () -> GristAmount.class;

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"minestuck");
    }

    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
    }

    public void registerIngredients(IModIngredientRegistration registry) {
        registry.register(GRIST, GristIngredientHelper.createList(), (IIngredientHelper)new GristIngredientHelper(), (IIngredientRenderer)new GristIngredientRenderer());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        GristCostRecipeCategory alchemiterCategory = new GristCostRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{alchemiterCategory});
        TotemLatheRecipeCategory totemLatheCategory = new TotemLatheRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{totemLatheCategory});
        DesignixRecipeCategory designixCategory = new DesignixRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{designixCategory});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MSBlocks.ALCHEMITER), new RecipeType[]{GRIST_COST});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MSBlocks.MINI_ALCHEMITER.get()), new RecipeType[]{GRIST_COST});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MSBlocks.TOTEM_LATHE), new RecipeType[]{LATHE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MSBlocks.MINI_TOTEM_LATHE.get()), new RecipeType[]{LATHE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MSBlocks.PUNCH_DESIGNIX), new RecipeType[]{DESIGNIX});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MSBlocks.MINI_PUNCH_DESIGNIX.get()), new RecipeType[]{DESIGNIX});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MSBlocks.CRUXITE_DOWEL.get()), new RecipeType[]{GRIST_COST, LATHE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MSItems.CAPTCHA_CARD.get()), new RecipeType[]{LATHE, DESIGNIX});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel level = Minecraft.getInstance().level;
        RecipeManager recipeManager = ((Level)Objects.requireNonNull(level)).getRecipeManager();
        registration.addRecipes(GRIST_COST, recipeManager.getAllRecipesFor(MSRecipeTypes.GRIST_COST_TYPE.get()).stream().flatMap(arg_0 -> MinestuckJeiPlugin.lambda$registerRecipes$1((Level)level, arg_0)).toList());
        registration.addRecipes(LATHE, recipeManager.getAllRecipesFor(MSRecipeTypes.COMBINATION_TYPE.get()).stream().flatMap(holder -> ((CombinationRecipe)holder.value()).getJeiCombinations().stream()).filter(combination -> combination.mode() == CombinationMode.AND).toList());
        registration.addRecipes(DESIGNIX, recipeManager.getAllRecipesFor(MSRecipeTypes.COMBINATION_TYPE.get()).stream().flatMap(holder -> ((CombinationRecipe)holder.value()).getJeiCombinations().stream()).filter(combination -> combination.mode() == CombinationMode.OR).toList());
    }

    private static /* synthetic */ Stream lambda$registerRecipes$1(Level level, RecipeHolder holder) {
        return ((GristCostRecipe)holder.value()).getJeiCosts(level).stream();
    }
}

