/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.jei;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.api.alchemy.recipe.combination.JeiCombination;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.components.EncodedItemComponent;
import com.mraof.minestuck.jei.MinestuckJeiPlugin;
import com.mraof.minestuck.player.ClientPlayerData;
import com.mraof.minestuck.util.ColorHandler;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TotemLatheRecipeCategory
implements IRecipeCategory<JeiCombination> {
    private final IDrawable background;
    private final IDrawable icon;

    TotemLatheRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation totemLatheBackground = Minestuck.id("textures/gui/totem_lathe.png");
        this.background = guiHelper.createDrawable(totemLatheBackground, 25, 24, 130, 36);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MSBlocks.TOTEM_LATHE));
    }

    public RecipeType<JeiCombination> getRecipeType() {
        return MinestuckJeiPlugin.LATHE;
    }

    public Component getTitle() {
        return Component.translatable((String)((Block)MSBlocks.TOTEM_LATHE.MIDDLE.get()).getDescriptionId());
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, JeiCombination recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients(recipe.input1());
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 19).addIngredients(recipe.input2());
        builder.addSlot(RecipeIngredientRole.INPUT, 37, 10).addItemStack(ColorHandler.setColor(new ItemStack((ItemLike)MSItems.CRUXITE_DOWEL.get()), ClientPlayerData.getPlayerColor()));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 10).addItemStack(recipe.output())).addItemStack(ColorHandler.setColor(EncodedItemComponent.createEncoded(MSItems.CRUXITE_DOWEL, recipe.output().getItem()), ClientPlayerData.getPlayerColor()));
    }
}

