/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.network;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.computer.editmode.ServerEditHandler;
import com.mraof.minestuck.inventory.captchalogue.CaptchaDeckHandler;
import com.mraof.minestuck.inventory.captchalogue.CaptchaDeckMenu;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import com.mraof.minestuck.network.MSPacket;
import com.mraof.minestuck.player.ClientPlayerData;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public final class CaptchaDeckPackets {

    public record SetModusParameter(byte parameterType, int parameterValue) implements MSPacket.PlayToServer
    {
        public static final CustomPacketPayload.Type<SetModusParameter> ID = new CustomPacketPayload.Type(Minestuck.id("captcha_deck/set_modus_parameter"));
        public static final StreamCodec<FriendlyByteBuf, SetModusParameter> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BYTE, SetModusParameter::parameterType, (StreamCodec)ByteBufCodecs.INT, SetModusParameter::parameterValue, SetModusParameter::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }

        @Override
        public void execute(IPayloadContext context, ServerPlayer player) {
            if (ServerEditHandler.isInEditmode(player)) {
                return;
            }
            Modus modus = CaptchaDeckHandler.getModus(player);
            if (modus != null) {
                modus.setValue(player, this.parameterType, this.parameterValue);
                modus.checkAndResend(player);
            }
        }
    }

    public record GetItem(int itemIndex, boolean asCard) implements MSPacket.PlayToServer
    {
        public static final CustomPacketPayload.Type<GetItem> ID = new CustomPacketPayload.Type(Minestuck.id("captcha_deck/get_item"));
        public static final StreamCodec<FriendlyByteBuf, GetItem> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, GetItem::itemIndex, (StreamCodec)ByteBufCodecs.BOOL, GetItem::asCard, GetItem::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }

        @Override
        public void execute(IPayloadContext context, ServerPlayer player) {
            if (ServerEditHandler.isInEditmode(player)) {
                return;
            }
            CaptchaDeckHandler.getItem(player, this.itemIndex, this.asCard);
        }
    }

    public record CaptchalogueInventorySlot(int slotIndex, int windowId) implements MSPacket.PlayToServer
    {
        public static final CustomPacketPayload.Type<CaptchalogueInventorySlot> ID = new CustomPacketPayload.Type(Minestuck.id("captcha_deck/captchalogue_inventory_slot"));
        public static final StreamCodec<RegistryFriendlyByteBuf, CaptchalogueInventorySlot> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CaptchalogueInventorySlot::slotIndex, (StreamCodec)ByteBufCodecs.INT, CaptchalogueInventorySlot::windowId, CaptchalogueInventorySlot::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }

        @Override
        public void execute(IPayloadContext context, ServerPlayer player) {
            if (ServerEditHandler.isInEditmode(player)) {
                return;
            }
            CaptchaDeckHandler.captchalogueItemInSlot(player, this.slotIndex, this.windowId);
        }
    }

    public record CaptchalogueHeldItem() implements MSPacket.PlayToServer
    {
        public static final CustomPacketPayload.Type<CaptchalogueHeldItem> ID = new CustomPacketPayload.Type(Minestuck.id("captcha_deck/captchalogue_held_item"));
        public static final StreamCodec<RegistryFriendlyByteBuf, CaptchalogueHeldItem> STREAM_CODEC = StreamCodec.unit((Object)new CaptchalogueHeldItem());

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }

        @Override
        public void execute(IPayloadContext context, ServerPlayer player) {
            if (ServerEditHandler.isInEditmode(player)) {
                return;
            }
            if (!player.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty()) {
                CaptchaDeckHandler.captchalogueItem(player);
            }
        }
    }

    public record TriggerModusButton() implements MSPacket.PlayToServer
    {
        public static final CustomPacketPayload.Type<TriggerModusButton> ID = new CustomPacketPayload.Type(Minestuck.id("captcha_deck/trigger_modus_button"));
        public static final StreamCodec<RegistryFriendlyByteBuf, TriggerModusButton> STREAM_CODEC = StreamCodec.unit((Object)new TriggerModusButton());

        @Override
        public void execute(IPayloadContext context, ServerPlayer player) {
            if (ServerEditHandler.isInEditmode(player)) {
                return;
            }
            if (player.containerMenu instanceof CaptchaDeckMenu) {
                CaptchaDeckHandler.useItem(player);
            }
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }

    public record ModusData(@Nullable CompoundTag nbt) implements MSPacket.PlayToClient
    {
        public static final CustomPacketPayload.Type<ModusData> ID = new CustomPacketPayload.Type(Minestuck.id("captcha_deck/modus_data"));
        public static final StreamCodec<RegistryFriendlyByteBuf, ModusData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, ModusData::nbt, ModusData::new);

        public static ModusData create(@Nullable Modus modus, HolderLookup.Provider provider) {
            return new ModusData(CaptchaDeckHandler.writeToNBT(modus, provider));
        }

        @Override
        public void execute(IPayloadContext context) {
            ClientPlayerData.handleDataPacket(this, (HolderLookup.Provider)context.player().registryAccess());
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }
}

