/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.network;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.client.gui.MSScreenFactories;
import com.mraof.minestuck.entity.dialogue.Dialogue;
import com.mraof.minestuck.entity.dialogue.DialogueComponent;
import com.mraof.minestuck.network.MSPacket;
import com.mraof.minestuck.util.MSAttachments;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public final class DialoguePackets {

    public record TriggerResponse(int responseIndex, int dialogueId) implements MSPacket.PlayToServer
    {
        public static final CustomPacketPayload.Type<TriggerResponse> ID = new CustomPacketPayload.Type(Minestuck.id("dialogue/trigger_response"));
        public static final StreamCodec<FriendlyByteBuf, TriggerResponse> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, TriggerResponse::responseIndex, (StreamCodec)ByteBufCodecs.INT, TriggerResponse::dialogueId, TriggerResponse::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }

        @Override
        public void execute(IPayloadContext context, ServerPlayer player) {
            ((DialogueComponent.CurrentDialogue)player.getData(MSAttachments.CURRENT_DIALOGUE)).validateAndGetComponent(player.level(), this.dialogueId).ifPresent(component -> this.findAndTriggerResponse(player, (DialogueComponent)component));
        }

        private void findAndTriggerResponse(ServerPlayer player, DialogueComponent component) {
            Optional<Dialogue.Node> optionalNode = component.validateAndGetCurrentNode(player);
            component.clearOngoingDialogue(player);
            optionalNode.flatMap(node -> node.getResponseIfValid(this.responseIndex)).ifPresent(response -> response.trigger(component, player));
        }
    }

    public record OnCloseScreen(int dialogueId) implements MSPacket.PlayToServer
    {
        public static final CustomPacketPayload.Type<OnCloseScreen> ID = new CustomPacketPayload.Type(Minestuck.id("dialogue/on_close_screen"));
        public static final StreamCodec<FriendlyByteBuf, OnCloseScreen> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, OnCloseScreen::dialogueId, OnCloseScreen::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }

        @Override
        public void execute(IPayloadContext context, ServerPlayer player) {
            ((DialogueComponent.CurrentDialogue)player.getData(MSAttachments.CURRENT_DIALOGUE)).validateAndGetComponent(player.level(), this.dialogueId).ifPresent(component -> component.clearOngoingDialogue(player));
        }
    }

    public record CloseScreen() implements MSPacket.PlayToClient
    {
        public static final CustomPacketPayload.Type<CloseScreen> ID = new CustomPacketPayload.Type(Minestuck.id("dialogue/close_screen"));
        public static final StreamCodec<FriendlyByteBuf, CloseScreen> STREAM_CODEC = StreamCodec.unit((Object)new CloseScreen());

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }

        @Override
        public void execute(IPayloadContext context) {
            MSScreenFactories.closeDialogueScreen();
        }
    }

    public record OpenScreen(int dialogueId, Dialogue.DialogueData dialogueData) implements MSPacket.PlayToClient
    {
        public static final CustomPacketPayload.Type<OpenScreen> ID = new CustomPacketPayload.Type(Minestuck.id("dialogue/open_screen"));
        public static final StreamCodec<RegistryFriendlyByteBuf, OpenScreen> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, OpenScreen::dialogueId, Dialogue.DialogueData.STREAM_CODEC, OpenScreen::dialogueData, OpenScreen::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }

        @Override
        public void execute(IPayloadContext context) {
            MSScreenFactories.displayDialogueScreen(this.dialogueId, this.dialogueData);
        }
    }
}

