/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.network;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.client.gui.playerStats.EcheladderScreen;
import com.mraof.minestuck.network.MSPacket;
import com.mraof.minestuck.player.ClientPlayerData;
import com.mraof.minestuck.player.Echeladder;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record EcheladderDataPacket(int rung, float progress, boolean sendMessage) implements MSPacket.PlayToClient
{
    public static final CustomPacketPayload.Type<EcheladderDataPacket> ID = new CustomPacketPayload.Type(Minestuck.id("echeladder_data"));
    public static final StreamCodec<RegistryFriendlyByteBuf, EcheladderDataPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, EcheladderDataPacket::rung, (StreamCodec)ByteBufCodecs.FLOAT, EcheladderDataPacket::progress, (StreamCodec)ByteBufCodecs.BOOL, EcheladderDataPacket::sendMessage, EcheladderDataPacket::new);

    public static EcheladderDataPacket create(int rung, float progress, boolean sendMessage) {
        return new EcheladderDataPacket(rung, progress, sendMessage);
    }

    public static EcheladderDataPacket init(int rung, float progress) {
        return new EcheladderDataPacket(rung, progress, false);
    }

    @Override
    public void execute(IPayloadContext context) {
        int prev = ClientPlayerData.getRung();
        ClientPlayerData.handleDataPacket(this);
        if (this.sendMessage) {
            ++prev;
            while (prev <= this.rung) {
                MutableComponent rung = Component.translatable((String)Echeladder.translationKey(prev));
                Minecraft.getInstance().player.sendSystemMessage((Component)Component.translatable((String)"echeladder.new_rung", (Object[])new Object[]{rung}));
                ++prev;
            }
        } else {
            EcheladderScreen.animatedRung = EcheladderScreen.lastRung = this.rung;
        }
    }

    public int getRung() {
        return this.rung;
    }

    public float getProgress() {
        return this.progress;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

