/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.network;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.alchemy.GristHelper;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.client.gui.toasts.GristToast;
import com.mraof.minestuck.computer.editmode.EditData;
import com.mraof.minestuck.computer.editmode.ServerEditHandler;
import com.mraof.minestuck.network.MSPacket;
import com.mraof.minestuck.player.PlayerIdentifier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record GristToastPacket(GristSet.Immutable gristValue, GristHelper.EnumSource source, boolean isCacheOwner) implements MSPacket.PlayToClient
{
    public static final CustomPacketPayload.Type<GristToastPacket> ID = new CustomPacketPayload.Type(Minestuck.id("grist_toast"));
    public static final StreamCodec<RegistryFriendlyByteBuf, GristToastPacket> STREAM_CODEC = StreamCodec.composite(GristSet.Codecs.STREAM_CODEC, GristToastPacket::gristValue, (StreamCodec)NeoForgeStreamCodecs.enumCodec(GristHelper.EnumSource.class), GristToastPacket::source, (StreamCodec)ByteBufCodecs.BOOL, GristToastPacket::isCacheOwner, GristToastPacket::new);

    public static void notify(MinecraftServer server, PlayerIdentifier player, GristSet set, GristHelper.EnumSource source) {
        if (((Boolean)MinestuckConfig.SERVER.showGristChanges.get()).booleanValue()) {
            if (player.getPlayer(server) != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player.getPlayer(server), (CustomPacketPayload)new GristToastPacket(set.asImmutable(), source, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (source == GristHelper.EnumSource.SERVER) {
                EditData ed = ServerEditHandler.getData(server, player);
                if (ed == null) {
                    return;
                }
                if (!player.appliesTo((Player)ed.getEditor())) {
                    PacketDistributor.sendToPlayer((ServerPlayer)ed.getEditor(), (CustomPacketPayload)new GristToastPacket(set.asImmutable(), source, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    @Override
    public void execute(IPayloadContext context) {
        GristToast.handlePacket(this);
    }
}

