/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.network;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.entity.LotusFlowerEntity;
import com.mraof.minestuck.network.MSPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record LotusFlowerAnimationPacket(int entityID, LotusFlowerEntity.Animation animation) implements MSPacket.PlayToClient
{
    public static final CustomPacketPayload.Type<LotusFlowerAnimationPacket> ID = new CustomPacketPayload.Type(Minestuck.id("lotus_flower_animation"));
    public static final StreamCodec<FriendlyByteBuf, LotusFlowerAnimationPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, LotusFlowerAnimationPacket::entityID, (StreamCodec)NeoForgeStreamCodecs.enumCodec(LotusFlowerEntity.Animation.class), LotusFlowerAnimationPacket::animation, LotusFlowerAnimationPacket::new);

    public static LotusFlowerAnimationPacket createPacket(LotusFlowerEntity entity, LotusFlowerEntity.Animation animation) {
        return new LotusFlowerAnimationPacket(entity.getId(), animation);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    @Override
    public void execute(IPayloadContext context) {
        Entity entity = Minecraft.getInstance().level.getEntity(this.entityID);
        if (entity instanceof LotusFlowerEntity) {
            LotusFlowerEntity lotusFlower = (LotusFlowerEntity)entity;
            lotusFlower.setAnimationFromPacket(this.animation);
        }
    }
}

