/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.network;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public interface MSPacket {
    public static <T> Optional<T> getAccessibleBlockEntity(ServerPlayer player, BlockPos pos, Class<T> castClass) {
        if (!player.level().isAreaLoaded(pos, 0) || player.distanceToSqr(Vec3.atCenterOf((Vec3i)pos)) > 64.0) {
            return Optional.empty();
        }
        BlockEntity blockEntity = player.level().getBlockEntity(pos);
        if (!castClass.isInstance(blockEntity)) {
            return Optional.empty();
        }
        return Optional.of(castClass.cast(blockEntity));
    }

    public static interface PlayToServer
    extends CustomPacketPayload {
        public void execute(IPayloadContext var1, ServerPlayer var2);
    }

    public static interface PlayToClient
    extends CustomPacketPayload {
        public void execute(IPayloadContext var1);
    }
}

