/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.network;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.computer.editmode.ServerEditHandler;
import com.mraof.minestuck.inventory.AtheneumMenu;
import com.mraof.minestuck.inventory.EditmodeMenu;
import com.mraof.minestuck.inventory.captchalogue.CaptchaDeckMenu;
import com.mraof.minestuck.network.MSPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record MiscContainerPacket(int index, boolean editmode) implements MSPacket.PlayToServer
{
    public static final CustomPacketPayload.Type<MiscContainerPacket> ID = new CustomPacketPayload.Type(Minestuck.id("misc_container"));
    public static final StreamCodec<FriendlyByteBuf, MiscContainerPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, MiscContainerPacket::index, (StreamCodec)ByteBufCodecs.BOOL, MiscContainerPacket::editmode, MiscContainerPacket::new);
    private static final Logger LOGGER = LogManager.getLogger();

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    @Override
    public void execute(IPayloadContext context, ServerPlayer player) {
        boolean isInEditmode = ServerEditHandler.isInEditmode(player);
        if (this.editmode != isInEditmode) {
            if (isInEditmode) {
                LOGGER.error("Sanity check failed: {} tried to open a minestuck gui while in editmode", (Object)player.getName().getString());
            } else {
                LOGGER.error("Sanity check failed: {} tried to open an editmode gui while outside editmode", (Object)player.getName().getString());
            }
            ServerEditHandler.resendEditmodeStatus(player);
        } else {
            int id = 105 + this.index;
            AbstractContainerMenu menu = !isInEditmode ? new CaptchaDeckMenu(id, player.getInventory()) : (this.index == 0 ? new EditmodeMenu(id, player.getInventory()) : new AtheneumMenu(id, player.getInventory()));
            player.containerMenu = menu;
            player.initMenu(menu);
            NeoForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)player, menu));
        }
    }
}

