/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.network;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.network.MSPacket;
import com.mraof.minestuck.player.ClientPlayerData;
import com.mraof.minestuck.util.ColorHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@MethodsReturnNonnullByDefault
public final class PlayerColorPackets {

    public record SelectRGB(int color) implements MSPacket.PlayToServer
    {
        public static final CustomPacketPayload.Type<SelectRGB> ID = new CustomPacketPayload.Type(Minestuck.id("player_color/select_rgb"));
        public static final StreamCodec<ByteBuf, SelectRGB> STREAM_CODEC = ByteBufCodecs.INT.map(SelectRGB::new, SelectRGB::color);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }

        @Override
        public void execute(IPayloadContext context, ServerPlayer player) {
            ColorHandler.trySetPlayerColor(player, this.color);
        }
    }

    public record SelectIndex(int colorIndex) implements MSPacket.PlayToServer
    {
        public static final CustomPacketPayload.Type<SelectIndex> ID = new CustomPacketPayload.Type(Minestuck.id("player_color/select_index"));
        public static final StreamCodec<ByteBuf, SelectIndex> STREAM_CODEC = ByteBufCodecs.INT.map(SelectIndex::new, SelectIndex::colorIndex);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }

        @Override
        public void execute(IPayloadContext context, ServerPlayer player) {
            ColorHandler.trySetPlayerColor(player, ColorHandler.BuiltinColors.getColor(this.colorIndex));
        }
    }

    public record Data(int color) implements MSPacket.PlayToClient
    {
        public static final CustomPacketPayload.Type<Data> ID = new CustomPacketPayload.Type(Minestuck.id("player_color/data"));
        public static final StreamCodec<ByteBuf, Data> STREAM_CODEC = ByteBufCodecs.INT.map(Data::new, Data::color);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }

        @Override
        public void execute(IPayloadContext context) {
            ClientPlayerData.handleDataPacket(this);
        }
    }

    public record OpenSelection() implements MSPacket.PlayToClient
    {
        public static final CustomPacketPayload.Type<OpenSelection> ID = new CustomPacketPayload.Type(Minestuck.id("player_color/open_selection"));
        public static final StreamCodec<FriendlyByteBuf, OpenSelection> STREAM_CODEC = StreamCodec.unit((Object)new OpenSelection());

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }

        @Override
        public void execute(IPayloadContext context) {
            ClientPlayerData.handleDataPacket(this);
        }
    }
}

