/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.network;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.entity.ServerCursorEntity;
import com.mraof.minestuck.network.MSPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerCursorAnimationPacket(int entityID, ServerCursorEntity.AnimationType animation) implements MSPacket.PlayToClient
{
    public static final CustomPacketPayload.Type<ServerCursorAnimationPacket> ID = new CustomPacketPayload.Type(Minestuck.id("server_cursor_animation"));
    public static final StreamCodec<FriendlyByteBuf, ServerCursorAnimationPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ServerCursorAnimationPacket::entityID, (StreamCodec)NeoForgeStreamCodecs.enumCodec(ServerCursorEntity.AnimationType.class), ServerCursorAnimationPacket::animation, ServerCursorAnimationPacket::new);

    public static ServerCursorAnimationPacket createPacket(ServerCursorEntity entity, ServerCursorEntity.AnimationType animation) {
        return new ServerCursorAnimationPacket(entity.getId(), animation);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    @Override
    public void execute(IPayloadContext context) {
        Entity entity = Minecraft.getInstance().level.getEntity(this.entityID);
        if (entity instanceof ServerCursorEntity) {
            ServerCursorEntity cursorEntity = (ServerCursorEntity)entity;
            cursorEntity.setAnimationFromPacket(this.animation);
        }
    }
}

