/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.network.computer;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.blockentity.ComputerBlockEntity;
import com.mraof.minestuck.computer.DiskBurnerData;
import com.mraof.minestuck.computer.ProgramTypes;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.network.MSPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record BurnDiskPacket(BlockPos computerPos, boolean isClientDisk) implements MSPacket.PlayToServer
{
    public static final CustomPacketPayload.Type<BurnDiskPacket> ID = new CustomPacketPayload.Type(Minestuck.id("burn_disk"));
    public static final StreamCodec<FriendlyByteBuf, BurnDiskPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, BurnDiskPacket::computerPos, (StreamCodec)ByteBufCodecs.BOOL, BurnDiskPacket::isClientDisk, BurnDiskPacket::new);

    public static BurnDiskPacket create(ComputerBlockEntity be, boolean isClientDisk) {
        return new BurnDiskPacket(be.getBlockPos(), isClientDisk);
    }

    public CustomPacketPayload.Type<BurnDiskPacket> type() {
        return ID;
    }

    @Override
    public void execute(IPayloadContext context, ServerPlayer player) {
        ComputerBlockEntity.getAccessibleComputer(player, this.computerPos).ifPresent(this::tryBurnDisk);
    }

    private void tryBurnDisk(ComputerBlockEntity computer) {
        Item disk = this.isClientDisk ? (Item)MSItems.CLIENT_DISK.get() : (Item)MSItems.SERVER_DISK.get();
        Level level = computer.getLevel();
        if (level == null) {
            return;
        }
        if (!computer.getProgramData(ProgramTypes.DISK_BURNER).map(DiskBurnerData::hasAllCode).orElse(false).booleanValue()) {
            return;
        }
        if (computer.tryConsumeBlankDisk()) {
            BlockPos pos = computer.getBlockPos();
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)disk.getDefaultInstance());
        }
    }
}

