/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.network.computer;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.blockentity.ComputerBlockEntity;
import com.mraof.minestuck.computer.SburbClientData;
import com.mraof.minestuck.computer.SburbServerData;
import com.mraof.minestuck.network.MSPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ClearMessagePacket(BlockPos computerPos, int program) implements MSPacket.PlayToServer
{
    public static final CustomPacketPayload.Type<ClearMessagePacket> ID = new CustomPacketPayload.Type(Minestuck.id("clear_message"));
    public static final StreamCodec<FriendlyByteBuf, ClearMessagePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ClearMessagePacket::computerPos, (StreamCodec)ByteBufCodecs.INT, ClearMessagePacket::program, ClearMessagePacket::new);

    public CustomPacketPayload.Type<ClearMessagePacket> type() {
        return ID;
    }

    @Override
    public void execute(IPayloadContext context, ServerPlayer player) {
        ComputerBlockEntity.getAccessibleComputer(player, this.computerPos).ifPresent(computer -> {
            if (this.program == 0) {
                computer.getSburbClientData().ifPresent(SburbClientData::clearEventMessage);
            }
            if (this.program == 1) {
                computer.getSburbServerData().ifPresent(SburbServerData::clearEventMessage);
            }
        });
    }
}

