/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.network.editmode;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.api.alchemy.GristAmount;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.GristCostRecipe;
import com.mraof.minestuck.computer.editmode.DeployEntry;
import com.mraof.minestuck.computer.editmode.DeployList;
import com.mraof.minestuck.computer.editmode.EditData;
import com.mraof.minestuck.computer.editmode.EditTools;
import com.mraof.minestuck.computer.editmode.ServerEditHandler;
import com.mraof.minestuck.network.MSPacket;
import com.mraof.minestuck.network.MSPayloads;
import com.mraof.minestuck.player.GristCache;
import com.mraof.minestuck.util.MSAttachments;
import com.mraof.minestuck.util.MSSoundEvents;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public final class EditmodeDragPackets {
    private static boolean editModePlaceCheck(EditData data, Player player, GristSet cost, BlockPos pos, Consumer<GristSet> missingGristTracker) {
        if (!player.level().getBlockState(pos).canBeReplaced()) {
            return false;
        }
        if (!data.getGristCache().canAfford(cost)) {
            missingGristTracker.accept(cost);
            return false;
        }
        return true;
    }

    private static boolean editModeDestroyCheck(EditData data, Player player, BlockPos pos, Consumer<GristSet> missingGristTracker) {
        BlockState block = player.level().getBlockState(pos);
        ItemStack stack = block.getCloneItemStack(null, (LevelReader)player.level(), pos, player);
        DeployEntry entry = DeployList.getEntryForItem(stack, data.sburbData(), player.level(), DeployList.EntryLists.ATHENEUM);
        if (block.isAir()) {
            return false;
        }
        if (!((Boolean)MinestuckConfig.SERVER.gristRefund.get()).booleanValue() && entry == null) {
            GristAmount cost = GristTypes.BUILD.get().amount(1L);
            if (!data.getGristCache().canAfford(cost)) {
                missingGristTracker.accept(cost);
                return false;
            }
        }
        return true;
    }

    public record Reset() implements MSPacket.PlayToServer
    {
        public static final CustomPacketPayload.Type<Reset> ID = new CustomPacketPayload.Type(Minestuck.id("editmode_drag/reset"));
        public static final StreamCodec<FriendlyByteBuf, Reset> STREAM_CODEC = StreamCodec.unit((Object)new Reset());

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }

        @Override
        public void execute(IPayloadContext context, ServerPlayer player) {
            if (!player.level().isClientSide()) {
                EditTools cap = (EditTools)player.getData(MSAttachments.EDIT_TOOLS);
                ServerEditHandler.removeCursorEntity(player, true);
                cap.resetDragTools();
            }
        }
    }

    public record Cursor(boolean isDown, BlockPos positionStart, BlockPos positionEnd) implements MSPacket.PlayToServer
    {
        public static final CustomPacketPayload.Type<Cursor> ID = new CustomPacketPayload.Type(Minestuck.id("editmode_drag/cursor"));
        public static final StreamCodec<FriendlyByteBuf, Cursor> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, Cursor::isDown, (StreamCodec)BlockPos.STREAM_CODEC, Cursor::positionStart, (StreamCodec)BlockPos.STREAM_CODEC, Cursor::positionEnd, Cursor::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }

        @Override
        public void execute(IPayloadContext context, ServerPlayer player) {
            if (ServerEditHandler.isInEditmode(player)) {
                EditTools cap = (EditTools)player.getData(MSAttachments.EDIT_TOOLS);
                cap.setEditPos1(this.positionStart);
                cap.setEditPos2(this.positionEnd);
                ServerEditHandler.updateEditToolsServer(player, this.isDown, this.positionStart, this.positionEnd);
            }
        }
    }

    public record Destroy(boolean isDown, BlockPos positionStart, BlockPos positionEnd, Vec3 hitVector, Direction side) implements MSPacket.PlayToServer
    {
        public static final CustomPacketPayload.Type<Destroy> ID = new CustomPacketPayload.Type(Minestuck.id("editmode_drag/destroy"));
        public static final StreamCodec<FriendlyByteBuf, Destroy> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, Destroy::isDown, (StreamCodec)BlockPos.STREAM_CODEC, Destroy::positionStart, (StreamCodec)BlockPos.STREAM_CODEC, Destroy::positionEnd, MSPayloads.VEC3_STREAM_CODEC, Destroy::hitVector, (StreamCodec)Direction.STREAM_CODEC, Destroy::side, Destroy::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }

        @Override
        public void execute(IPayloadContext context, ServerPlayer player) {
            EditData data = ServerEditHandler.getData((Player)player);
            if (data == null) {
                return;
            }
            EditTools cap = (EditTools)player.getData(MSAttachments.EDIT_TOOLS);
            cap.setEditPos1(this.positionStart);
            cap.setEditPos2(this.positionEnd);
            cap.setEditTrace(this.hitVector, this.side);
            MutableGristSet missingCost = MutableGristSet.newDefault();
            boolean anyBlockDestroyed = false;
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)this.positionStart, (BlockPos)this.positionEnd)) {
                BlockState block = player.level().getBlockState(pos);
                Consumer<GristSet> missingCostTracker = missingCost::add;
                if (!EditmodeDragPackets.editModeDestroyCheck(data, (Player)player, pos, missingCostTracker)) continue;
                player.gameMode.destroyAndAck(pos, 3, "creative destroy");
                player.level().levelEvent(2001, pos, Block.getId((BlockState)block));
                player.level().gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of((Entity)player, (BlockState)block));
                anyBlockDestroyed = true;
            }
            if (anyBlockDestroyed) {
                player.level().playSound((Player)player, this.positionEnd, MSSoundEvents.EVENT_EDIT_TOOL_RECYCLE.get(), SoundSource.AMBIENT, 1.0f, 0.85f);
                player.swing(InteractionHand.MAIN_HAND);
            }
            if (!missingCost.isEmpty()) {
                player.sendSystemMessage(GristCache.createMissingMessage(missingCost), true);
            }
            ServerEditHandler.removeCursorEntity(player, !anyBlockDestroyed);
        }
    }

    public record Fill(boolean isDown, BlockPos positionStart, BlockPos positionEnd, Vec3 hitVector, Direction side) implements MSPacket.PlayToServer
    {
        public static final CustomPacketPayload.Type<Fill> ID = new CustomPacketPayload.Type(Minestuck.id("editmode_drag/fill"));
        public static final StreamCodec<FriendlyByteBuf, Fill> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, Fill::isDown, (StreamCodec)BlockPos.STREAM_CODEC, Fill::positionStart, (StreamCodec)BlockPos.STREAM_CODEC, Fill::positionEnd, MSPayloads.VEC3_STREAM_CODEC, Fill::hitVector, (StreamCodec)Direction.STREAM_CODEC, Fill::side, Fill::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }

        @Override
        public void execute(IPayloadContext context, ServerPlayer player) {
            EditData data = ServerEditHandler.getData((Player)player);
            if (data == null) {
                return;
            }
            EditTools cap = (EditTools)player.getData(MSAttachments.EDIT_TOOLS);
            cap.setEditPos1(this.positionStart);
            cap.setEditPos2(this.positionEnd);
            cap.setEditTrace(this.hitVector, this.side);
            InteractionHand hand = player.getMainHandItem().isEmpty() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
            ItemStack stack = player.getItemInHand(hand);
            if (stack.isEmpty() || !(stack.getItem() instanceof BlockItem)) {
                return;
            }
            DeployEntry entry = DeployList.getEntryForItem(stack, data.sburbData(), player.level());
            GristSet cost = entry != null ? entry.getCurrentCost(data.sburbData()) : GristCostRecipe.findCostForItem(stack, null, false, player.level());
            MutableGristSet missingCost = MutableGristSet.newDefault();
            boolean anyBlockPlaced = false;
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)this.positionStart, (BlockPos)this.positionEnd)) {
                int c = stack.getCount();
                if (!EditmodeDragPackets.editModePlaceCheck(data, (Player)player, cost, pos, missingCost::add) || stack.useOn(new UseOnContext((Player)player, hand, new BlockHitResult(this.hitVector, this.side, pos, false))) == InteractionResult.FAIL) continue;
                if (player.isCreative()) {
                    stack.setCount(c);
                }
                SoundType soundType = ((BlockItem)stack.getItem()).getBlock().defaultBlockState().getSoundType();
                player.level().playSound((Player)player, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
                anyBlockPlaced = true;
            }
            if (anyBlockPlaced) {
                player.level().playSound((Player)player, this.positionEnd, MSSoundEvents.EVENT_EDIT_TOOL_REVISE.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                player.swing(hand);
            }
            if (!missingCost.isEmpty()) {
                player.sendSystemMessage(GristCache.createMissingMessage(missingCost), true);
            }
            ServerEditHandler.removeCursorEntity(player, !anyBlockPlaced);
        }
    }
}

