/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.network.editmode;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.computer.editmode.EditData;
import com.mraof.minestuck.computer.editmode.EditmodeLocations;
import com.mraof.minestuck.network.MSPacket;
import com.mraof.minestuck.world.storage.MSExtraData;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record EditmodeTeleportPacket(BlockPos pos) implements MSPacket.PlayToServer
{
    public static final CustomPacketPayload.Type<EditmodeTeleportPacket> ID = new CustomPacketPayload.Type(Minestuck.id("editmode_teleport"));
    public static final StreamCodec<ByteBuf, EditmodeTeleportPacket> STREAM_CODEC = BlockPos.STREAM_CODEC.map(EditmodeTeleportPacket::new, EditmodeTeleportPacket::pos);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    @Override
    public void execute(IPayloadContext context, ServerPlayer player) {
        EditData editData = MSExtraData.get((Level)player.serverLevel()).findEditData(data -> data.getEditor() == player);
        if (editData == null) {
            return;
        }
        if (EditmodeLocations.checkIsValidSourcePos(editData, (ResourceKey<Level>)player.level().dimension(), this.pos)) {
            player.teleportTo((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 1.0, (double)this.pos.getZ() + 0.5);
        }
    }
}

