/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.player;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.client.ClientRungData;
import com.mraof.minestuck.client.gui.ColorSelectorScreen;
import com.mraof.minestuck.client.gui.MSScreenFactories;
import com.mraof.minestuck.inventory.captchalogue.CaptchaDeckHandler;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import com.mraof.minestuck.network.BoondollarDataPacket;
import com.mraof.minestuck.network.CaptchaDeckPackets;
import com.mraof.minestuck.network.DataCheckerPackets;
import com.mraof.minestuck.network.EcheladderDataPacket;
import com.mraof.minestuck.network.GristCachePacket;
import com.mraof.minestuck.network.PlayerColorPackets;
import com.mraof.minestuck.network.TitleDataPacket;
import com.mraof.minestuck.network.editmode.EditmodeCacheLimitPacket;
import com.mraof.minestuck.player.GristCache;
import com.mraof.minestuck.player.Title;
import com.mraof.minestuck.util.ColorHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public final class ClientPlayerData {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Modus modus;
    private static Title title;
    private static int rung;
    private static float rungProgress;
    private static long boondollars;
    private static GristSet playerGrist;
    private static GristSet targetGrist;
    private static long targetCacheLimit;
    private static int playerColor;
    private static boolean displaySelectionGui;
    private static boolean dataCheckerAccess;

    @SubscribeEvent
    private static void onLoggedIn(ClientPlayerNetworkEvent.LoggingIn event) {
        modus = null;
        title = null;
        rung = -1;
        playerColor = -1;
        displaySelectionGui = false;
    }

    public static Modus getModus() {
        return modus;
    }

    public static Title getTitle() {
        return title;
    }

    public static int getRung() {
        return rung;
    }

    public static float getRungProgress() {
        return rungProgress;
    }

    public static long getBoondollars() {
        return boondollars;
    }

    public static ClientCache getGristCache(CacheSource cacheSource) {
        return switch (cacheSource.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new ClientCache(playerGrist, ClientRungData.getData(ClientPlayerData.getRung()).gristCapacity());
            case 1 -> new ClientCache(targetGrist, targetCacheLimit);
        };
    }

    public static int getPlayerColor() {
        return playerColor;
    }

    public static void selectColor(int colorIndex) {
        PacketDistributor.sendToServer((CustomPacketPayload)new PlayerColorPackets.SelectIndex(colorIndex), (CustomPacketPayload[])new CustomPacketPayload[0]);
        playerColor = ColorHandler.BuiltinColors.getColor(colorIndex);
    }

    public static void selectColorRGB(int color) {
        if (color < 0 || color > 0x1000000) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new PlayerColorPackets.SelectRGB(color), (CustomPacketPayload[])new CustomPacketPayload[0]);
        playerColor = color;
    }

    public static boolean hasDataCheckerAccess() {
        return dataCheckerAccess;
    }

    public static void handleDataPacket(CaptchaDeckPackets.ModusData packet, HolderLookup.Provider provider) {
        modus = CaptchaDeckHandler.readFromNBT(packet.nbt(), LogicalSide.CLIENT, provider);
        if (modus != null) {
            MSScreenFactories.updateSylladexScreen();
        } else {
            LOGGER.debug("Player lost their modus after update packet");
        }
    }

    public static void handleDataPacket(TitleDataPacket packet) {
        title = packet.getTitle();
    }

    public static void handleDataPacket(EcheladderDataPacket packet) {
        rung = packet.getRung();
        rungProgress = packet.getProgress();
    }

    public static void handleDataPacket(BoondollarDataPacket packet) {
        boondollars = packet.amount();
    }

    public static void handleDataPacket(GristCachePacket packet) {
        switch (packet.cacheSource().ordinal()) {
            case 0: {
                playerGrist = packet.gristCache();
                break;
            }
            case 1: {
                targetGrist = packet.gristCache();
            }
        }
    }

    public static void handleDataPacket(EditmodeCacheLimitPacket packet) {
        targetCacheLimit = packet.limit();
    }

    public static void handleDataPacket(PlayerColorPackets.OpenSelection packet) {
        playerColor = 10542335;
        displaySelectionGui = true;
    }

    public static void handleDataPacket(PlayerColorPackets.Data packet) {
        playerColor = packet.color();
    }

    public static void handleDataPacket(DataCheckerPackets.Permission packet) {
        dataCheckerAccess = packet.isAvailable();
    }

    @SubscribeEvent
    private static void onClientTick(ClientTickEvent.Post event) {
        if (displaySelectionGui && Minecraft.getInstance().screen == null) {
            displaySelectionGui = false;
            if (((Boolean)MinestuckConfig.CLIENT.loginColorSelector.get()).booleanValue()) {
                Minecraft.getInstance().setScreen((Screen)new ColorSelectorScreen(true));
            }
        }
    }

    public static enum CacheSource {
        PLAYER,
        EDITMODE;

    }

    public record ClientCache(GristSet set, long limit) {
        public boolean canAfford(GristSet cost) {
            return GristCache.canAfford(this.set, cost, this.limit);
        }
    }
}

