/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.player;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.advancements.MSCriteriaTriggers;
import com.mraof.minestuck.computer.editmode.EditData;
import com.mraof.minestuck.computer.editmode.ServerEditHandler;
import com.mraof.minestuck.network.EcheladderDataPacket;
import com.mraof.minestuck.player.EcheladderBonusType;
import com.mraof.minestuck.player.EnumAspect;
import com.mraof.minestuck.player.PlayerBoondollars;
import com.mraof.minestuck.player.PlayerData;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.player.Rungs;
import com.mraof.minestuck.player.Title;
import com.mraof.minestuck.util.MSAttachments;
import com.mraof.minestuck.util.MSSoundEvents;
import java.util.EnumSet;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@MethodsReturnNonnullByDefault
@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public final class Echeladder
implements INBTSerializable<CompoundTag> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String NEW_RUNG = "echeladder.new_rung";
    private final MinecraftServer mcServer;
    private final PlayerIdentifier identifier;
    private int rung;
    private int progress;
    private final EnumSet<EcheladderBonusType> usedBonuses = EnumSet.noneOf(EcheladderBonusType.class);

    public static Echeladder get(PlayerIdentifier player, Level level) {
        return Echeladder.get(PlayerData.get(player, level));
    }

    public static Echeladder get(ServerPlayer player) {
        PlayerData playerData = PlayerData.get(player).orElseThrow(() -> new IllegalArgumentException("Cannot get player data for player " + String.valueOf(player)));
        return Echeladder.get(playerData);
    }

    public static Echeladder get(PlayerData playerData) {
        return (Echeladder)playerData.getData(MSAttachments.ECHELADDER);
    }

    @SubscribeEvent
    private static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        Echeladder echeladder = Echeladder.get(player);
        echeladder.updateEcheladderBonuses(player);
        echeladder.sendInitialPacket(player);
    }

    @SubscribeEvent
    private static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        Echeladder echeladder = Echeladder.get(player);
        echeladder.updateEcheladderBonuses(player);
        if (((Boolean)MinestuckConfig.SERVER.rungHealthOnRespawn.get()).booleanValue()) {
            event.getEntity().heal(event.getEntity().getMaxHealth());
        }
    }

    public Echeladder(PlayerData playerData) {
        this.mcServer = playerData.getMinecraftServer();
        this.identifier = playerData.identifier;
    }

    public void increaseProgress(double exp) {
        long boondollarsGained;
        int prevRung;
        ServerPlayer player;
        block11: {
            exp = exp / (double)(this.rung + 1) * 2.0;
            player = this.identifier.getPlayer(this.mcServer);
            if (player == null) {
                return;
            }
            int topRung = Rungs.getMaxAttainableRung(player) - 1;
            long expReq = Rungs.getProgressReq(this.rung);
            if (this.rung >= topRung) {
                return;
            }
            prevRung = this.rung;
            LOGGER.debug("Adding {} exp(modified) to player {}'s echeladder (previously at rung {} progress {}/{})", (Object)exp, (Object)this.identifier.getUsername(), (Object)this.rung, (Object)this.progress, (Object)expReq);
            boondollarsGained = 0L;
            while ((double)this.progress + exp >= (double)expReq) {
                ++this.rung;
                boondollarsGained += Rungs.getBoondollarsGained(this.rung);
                exp -= (double)(expReq - (long)this.progress);
                this.progress = 0;
                expReq = Rungs.getProgressReq(this.rung);
                if (this.rung < topRung) {
                    if (this.rung > prevRung + 1) {
                        exp = (int)(exp / 1.5);
                    }
                    LOGGER.debug("Increased rung to {}, remaining exp is {}", (Object)this.rung, (Object)exp);
                    continue;
                }
                break block11;
            }
            if (exp >= 1.0) {
                this.progress += (int)exp;
                LOGGER.debug("Added remainder exp to progress, which is now at {}", (Object)this.progress);
            } else {
                int bound = (int)(2.0 / exp);
                if (RandomSource.create().nextInt(bound) == 1) {
                    ++this.progress;
                    LOGGER.debug("Remaining exp {} is below 1, added 1 exp to progress with 1 in {} chance", (Object)exp, (Object)bound);
                } else {
                    LOGGER.debug("Remaining exp {} is below 1, failed to add 1 exp to progress with 1 in {} chance", (Object)exp, (Object)bound);
                }
            }
        }
        PlayerBoondollars.addBoondollars(PlayerData.get(this.identifier, this.mcServer), boondollarsGained);
        LOGGER.debug("Finished echeladder climbing for {} at {} with progress {}", (Object)this.identifier.getUsername(), (Object)this.rung, (Object)this.progress);
        this.sendDataPacket(player, true);
        if (this.rung != prevRung) {
            this.updateEcheladderBonuses(player);
            MSCriteriaTriggers.ECHELADDER.get().trigger(player, this.rung);
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), MSSoundEvents.EVENT_ECHELADDER_INCREASE.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            EditData data = ServerEditHandler.getData(this.mcServer, this.identifier);
            if (data != null) {
                data.sendCacheLimitToEditor();
            }
        }
    }

    public void checkBonus(EcheladderBonusType type) {
        if (!this.usedBonuses.contains((Object)type)) {
            this.usedBonuses.add(type);
            this.increaseProgress(type.getBonus());
        }
    }

    public int getRung() {
        return this.rung;
    }

    public float getProgress() {
        return (float)this.progress / (float)Rungs.getProgressReq(this.rung);
    }

    public void updateEcheladderBonuses(ServerPlayer player) {
        EnumAspect aspect = Title.getTitle(player).map(Title::heroAspect).orElse(null);
        Rungs.getRelevantAttributes(aspect, this.rung).forEach(attribute -> attribute.updateAttribute(player, this.rung));
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("rung", this.rung);
        nbt.putInt("rungProgress", this.progress);
        ListTag bonuses = new ListTag();
        for (EcheladderBonusType bonus : this.usedBonuses) {
            bonuses.add((Object)StringTag.valueOf((String)bonus.toString()));
        }
        nbt.put("rungBonuses", (Tag)bonuses);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.rung = nbt.getInt("rung");
        this.progress = nbt.getInt("rungProgress");
        for (Tag tag : nbt.getList("rungBonuses", 8)) {
            this.usedBonuses.add(EcheladderBonusType.fromString(tag.getAsString()));
        }
    }

    public long getGristCapacity() {
        return Rungs.getGristCapacity(this.rung);
    }

    public void setByCommand(int rung, double progress) {
        ServerPlayer player;
        int prevRung = this.rung;
        int prevProgress = this.progress;
        this.rung = Mth.clamp((int)rung, (int)0, (int)Rungs.finalRung());
        if (rung != Rungs.finalRung()) {
            long progressReq = Rungs.getProgressReq(rung);
            this.progress = (int)((double)progressReq * progress);
            if ((long)this.progress >= progressReq) {
                --this.progress;
            }
        } else {
            this.progress = 0;
        }
        if (!(prevProgress == this.progress && prevRung == this.rung || (player = this.identifier.getPlayer(this.mcServer)) == null || !((Boolean)MinestuckConfig.SERVER.echeladderProgress.get()).booleanValue() && prevRung == this.rung)) {
            this.sendDataPacket(player, false);
            if (prevRung != this.rung) {
                this.updateEcheladderBonuses(player);
            }
        }
    }

    public void sendInitialPacket(ServerPlayer player) {
        EcheladderDataPacket packet = EcheladderDataPacket.init(this.getRung(), (Boolean)MinestuckConfig.SERVER.echeladderProgress.get() != false ? this.getProgress() : 0.0f);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sendDataPacket(ServerPlayer player, boolean sendMessage) {
        EcheladderDataPacket packet = EcheladderDataPacket.create(this.getRung(), (Boolean)MinestuckConfig.SERVER.echeladderProgress.get() != false ? this.getProgress() : 0.0f, sendMessage);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static String translationKey(int rung) {
        return "echeladder.rung." + rung;
    }
}

