/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.player;

import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.event.AlchemyEvent;
import com.mraof.minestuck.item.artifact.CruxiteArtifactItem;
import com.mraof.minestuck.player.Echeladder;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public enum EcheladderBonusType {
    IMP(10),
    OGRE(120),
    BASILISK(450),
    LICH(1200),
    GICLOPS(2500),
    ALCHEMY_1(30),
    ALCHEMY_2(400),
    ALCHEMY_3(3000);

    private final int bonus;

    private EcheladderBonusType(int bonus) {
        this.bonus = bonus;
    }

    public int getBonus() {
        return this.bonus;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static EcheladderBonusType fromString(String string) {
        for (EcheladderBonusType c : EcheladderBonusType.values()) {
            if (!c.toString().equalsIgnoreCase(string)) continue;
            return c;
        }
        return null;
    }

    @SubscribeEvent
    private static void onAlchemizedItem(AlchemyEvent event) {
        Echeladder e = Echeladder.get(event.getPlayer(), event.getLevel());
        if (!(event.getItemResult().getItem() instanceof CruxiteArtifactItem)) {
            e.checkBonus(ALCHEMY_1);
            GristSet cost = event.getCost();
            double value = cost.getValue();
            if (value >= 50.0) {
                e.checkBonus(ALCHEMY_2);
            }
            if (value >= 500.0) {
                e.checkBonus(ALCHEMY_3);
            }
        }
    }
}

