/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.player;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.player.Echeladder;
import com.mraof.minestuck.player.EcheladderExpSources;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.AdvancementEvent;

@ParametersAreNonnullByDefault
@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public interface EcheladderExpSource {
    public MapCodec<? extends EcheladderExpSource> codec();

    public void process(ServerPlayer var1);

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public static void onEntityDeath(LivingDeathEvent event) {
        ServerPlayer player;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof ServerPlayer && !((player = (ServerPlayer)entity) instanceof FakePlayer)) {
            for (EcheladderExpSource source : EcheladderExpSources.instance()) {
                KillEntityTag killEntityTagSource;
                KillEntity killEntitySource;
                if (source instanceof KillEntity && (killEntitySource = (KillEntity)source).matches(event.getEntity().getType())) {
                    killEntitySource.process(player);
                    return;
                }
                if (!(source instanceof KillEntityTag) || !(killEntityTagSource = (KillEntityTag)source).matches(event.getEntity().getType())) continue;
                killEntityTagSource.process(player);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onAdvancementGained(AdvancementEvent.AdvancementEarnEvent event) {
        for (EcheladderExpSource source : EcheladderExpSources.instance()) {
            AdvancementEarned advancementSource;
            if (!(source instanceof AdvancementEarned) || !(advancementSource = (AdvancementEarned)source).matches(event.getAdvancement().id())) continue;
            advancementSource.process((ServerPlayer)event.getEntity());
            return;
        }
    }

    private static void advance(ServerPlayer player, int exp) {
        Echeladder.get(player).increaseProgress(exp);
    }

    public record KillEntity(EntityType<?> entityType, int amount) implements EcheladderExpSource
    {
        static final MapCodec<KillEntity> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entity_type").forGetter(KillEntity::entityType), (App)Codec.INT.fieldOf("amount").forGetter(KillEntity::amount)).apply((Applicative)instance, KillEntity::new));

        @Override
        public MapCodec<? extends EcheladderExpSource> codec() {
            return CODEC;
        }

        public boolean matches(EntityType<?> entityType) {
            return this.entityType.equals(entityType);
        }

        @Override
        public void process(ServerPlayer player) {
            EcheladderExpSource.advance(player, this.amount);
        }
    }

    public record KillEntityTag(TagKey<EntityType<?>> entityTypeTag, int amount) implements EcheladderExpSource
    {
        static final MapCodec<KillEntityTag> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec((ResourceKey)BuiltInRegistries.ENTITY_TYPE.key()).fieldOf("entity_type_tag").forGetter(KillEntityTag::entityTypeTag), (App)Codec.INT.fieldOf("amount").forGetter(KillEntityTag::amount)).apply((Applicative)instance, KillEntityTag::new));

        @Override
        public MapCodec<? extends EcheladderExpSource> codec() {
            return CODEC;
        }

        public boolean matches(EntityType<?> entityType) {
            return entityType.is(this.entityTypeTag);
        }

        @Override
        public void process(ServerPlayer player) {
            EcheladderExpSource.advance(player, this.amount);
        }
    }

    public record AdvancementEarned(ResourceLocation advancementId, int amount) implements EcheladderExpSource
    {
        static final MapCodec<AdvancementEarned> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("advancement_id").forGetter(AdvancementEarned::advancementId), (App)Codec.INT.fieldOf("amount").forGetter(AdvancementEarned::amount)).apply((Applicative)instance, AdvancementEarned::new));

        @Override
        public MapCodec<? extends EcheladderExpSource> codec() {
            return CODEC;
        }

        public boolean matches(ResourceLocation advancementId) {
            return this.advancementId.equals((Object)advancementId);
        }

        @Override
        public void process(ServerPlayer player) {
            EcheladderExpSource.advance(player, this.amount);
        }
    }
}

