/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.player;

import com.mojang.serialization.Codec;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;

public enum EnumAspect implements StringRepresentable
{
    BLOOD,
    BREATH,
    DOOM,
    HEART,
    HOPE,
    LIFE,
    LIGHT,
    MIND,
    RAGE,
    SPACE,
    TIME,
    VOID;

    public static final Codec<EnumAspect> CODEC;

    public static EnumAspect getRandomAspect(EnumSet<EnumAspect> unavailableAspects, RandomSource rand) {
        EnumAspect[] list;
        if (unavailableAspects == null) {
            unavailableAspects = EnumSet.noneOf(EnumAspect.class);
        }
        if (unavailableAspects.size() == 12) {
            return null;
        }
        int aspectInt = rand.nextInt(12 - unavailableAspects.size());
        for (EnumAspect aspect : list = EnumAspect.values()) {
            if (unavailableAspects.contains((Object)aspect)) continue;
            if (aspectInt == 0) {
                return aspect;
            }
            --aspectInt;
        }
        return null;
    }

    public static EnumAspect getAspectFromInt(int i) {
        if (i < 0 || i >= EnumAspect.values().length) {
            return null;
        }
        return EnumAspect.values()[i];
    }

    public static int getIntFromAspect(EnumAspect e) {
        return e.ordinal();
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String toString() {
        return this.getSerializedName();
    }

    public static EnumAspect fromString(String string) {
        for (EnumAspect a : EnumAspect.values()) {
            if (!a.getSerializedName().equalsIgnoreCase(string)) continue;
            return a;
        }
        return null;
    }

    public Component asTextComponent() {
        return Component.translatable((String)this.getTranslationKey());
    }

    public String getTranslationKey() {
        return "title.aspect." + this.getSerializedName();
    }

    public static Set<EnumAspect> valuesSet() {
        return EnumSet.allOf(EnumAspect.class);
    }

    static {
        CODEC = StringRepresentable.fromEnum(EnumAspect::values);
    }
}

