/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.player;

import com.mojang.serialization.Codec;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;

public enum EnumClass implements StringRepresentable
{
    BARD(true),
    HEIR(true),
    KNIGHT(true),
    MAGE(true),
    MAID(true),
    PAGE(true),
    PRINCE(true),
    ROGUE(true),
    SEER(true),
    SYLPH(true),
    THIEF(true),
    WITCH(true),
    LORD(false),
    MUSE(false);

    private final boolean usedInGeneration;
    public static final Codec<EnumClass> CODEC;

    private EnumClass(boolean usedInGeneration) {
        this.usedInGeneration = usedInGeneration;
    }

    public static EnumClass getClassFromInt(int i) {
        if (i < 0 || i >= EnumClass.values().length) {
            return null;
        }
        return EnumClass.values()[i];
    }

    public static int getIntFromClass(EnumClass e) {
        return e.ordinal();
    }

    public static EnumClass fromString(String string) {
        for (EnumClass c : EnumClass.values()) {
            if (!c.getSerializedName().equalsIgnoreCase(string)) continue;
            return c;
        }
        return null;
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String toString() {
        return this.getSerializedName();
    }

    public Component asTextComponent() {
        return Component.translatable((String)this.getTranslationKey());
    }

    public String getTranslationKey() {
        return "title.class." + this.getSerializedName();
    }

    public boolean isUsedInGeneration() {
        return this.usedInGeneration;
    }

    public static Stream<EnumClass> valuesStream() {
        return Stream.of(EnumClass.values()).filter(EnumClass::isUsedInGeneration);
    }

    static {
        CODEC = StringRepresentable.fromEnum(EnumClass::values);
    }
}

