/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.player;

import com.mojang.serialization.DynamicOps;
import com.mraof.minestuck.alchemy.GristGutter;
import com.mraof.minestuck.alchemy.GristHelper;
import com.mraof.minestuck.api.alchemy.GristAmount;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.NonNegativeGristSet;
import com.mraof.minestuck.computer.editmode.EditData;
import com.mraof.minestuck.computer.editmode.ServerEditHandler;
import com.mraof.minestuck.entity.item.GristEntity;
import com.mraof.minestuck.network.GristCachePacket;
import com.mraof.minestuck.network.GristToastPacket;
import com.mraof.minestuck.player.ClientPlayerData;
import com.mraof.minestuck.player.Echeladder;
import com.mraof.minestuck.player.PlayerData;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.util.MSAttachments;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public final class GristCache
implements INBTSerializable<Tag> {
    public static final String MISSING_MESSAGE = "grist.missing";
    private static final Logger LOGGER = LogManager.getLogger();
    private final PlayerData data;
    private final MinecraftServer mcServer;
    private GristSet.Immutable gristSet;

    public GristCache(PlayerData data) {
        this.data = data;
        this.mcServer = data.getMinecraftServer();
        this.gristSet = GristTypes.BUILD.get().amount(20L);
    }

    public static GristCache get(ServerPlayer player) {
        PlayerData data = PlayerData.get(player).orElseThrow();
        return GristCache.get(data);
    }

    public static GristCache get(Level level, PlayerIdentifier player) {
        return GristCache.get(PlayerData.get(player, level));
    }

    public static GristCache get(MinecraftServer mcServer, PlayerIdentifier player) {
        return GristCache.get(PlayerData.get(player, mcServer));
    }

    public static GristCache get(PlayerData playerData) {
        return (GristCache)playerData.getData(MSAttachments.GRIST_CACHE);
    }

    public static Component createMissingMessage(GristSet gristSet) {
        return Component.translatable((String)MISSING_MESSAGE, (Object[])new Object[]{gristSet.asTextComponent()});
    }

    @SubscribeEvent
    private static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        GristCache.get(player).sendPacket(player);
    }

    public NonNegativeGristSet getCapacitySet() {
        long capacity = Echeladder.get(this.data).getGristCapacity();
        NonNegativeGristSet capacitySet = new NonNegativeGristSet();
        for (GristType type : GristTypes.REGISTRY) {
            long amountInCache = this.getGristSet().getGrist(type);
            if (amountInCache >= capacity) continue;
            capacitySet.add(type, capacity - amountInCache);
        }
        return capacitySet;
    }

    public void deserializeNBT(HolderLookup.Provider provider, Tag tag) {
        this.gristSet = GristSet.Codecs.NON_NEGATIVE_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(GristSet.EMPTY);
    }

    @Nullable
    public Tag serializeNBT(HolderLookup.Provider provider) {
        return GristSet.Codecs.NON_NEGATIVE_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.gristSet).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null);
    }

    public GristSet.Immutable getGristSet() {
        return this.gristSet;
    }

    public long getRemainingCapacity(GristType type) {
        return Math.max(0L, Echeladder.get(this.data).getGristCapacity() - this.gristSet.getGrist(type));
    }

    public boolean canAfford(GristSet cost) {
        return this.canAdd(cost.mutableCopy().scale(-1));
    }

    public boolean canAdd(GristSet addition) {
        return GristCache.addWithinCapacity(this.gristSet.mutableCopy(), addition, Echeladder.get(this.data).getGristCapacity()).isEmpty();
    }

    public static boolean canAfford(GristSet source, GristSet cost, long limit) {
        return GristCache.addWithinCapacity(source.mutableCopy(), cost.mutableCopy().scale(-1), limit).isEmpty();
    }

    public boolean tryTake(GristSet cost, @Nullable GristHelper.EnumSource source) {
        MutableGristSet change = cost.mutableCopy().scale(-1);
        NonNegativeGristSet newCache = new NonNegativeGristSet(this.getGristSet());
        MutableGristSet excessGrist = GristCache.addWithinCapacity(newCache, change, Echeladder.get(this.data).getGristCapacity());
        if (excessGrist.isEmpty()) {
            this.set(newCache);
            if (source != null) {
                GristToastPacket.notify(this.mcServer, this.data.identifier, change, source);
            }
            return true;
        }
        return false;
    }

    public void addWithGutter(GristSet set, @Nullable GristHelper.EnumSource source) {
        MutableGristSet overflowedGrist = this.addWithinCapacity(set, source);
        if (!overflowedGrist.isEmpty()) {
            GristGutter.get(this.data.identifier, this.mcServer).addGristFrom(overflowedGrist);
            GristToastPacket.notify(this.mcServer, this.data.identifier, set, GristHelper.EnumSource.GUTTER);
            ServerPlayer player = this.data.getPlayer();
            if (player != null && !overflowedGrist.isEmpty()) {
                int gusherCount = player.getRandom().nextInt(6) > 0 ? 1 : 2;
                GristEntity.spawnGristEntities(overflowedGrist, player.level(), player.getX(), player.getY(), player.getZ(), player.getRandom(), entity -> entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.5, 0.5, 1.5)), 90, gusherCount);
            }
        }
    }

    public MutableGristSet addWithinCapacity(GristSet set, @Nullable GristHelper.EnumSource source) {
        Objects.requireNonNull(set);
        NonNegativeGristSet newCache = new NonNegativeGristSet(this.getGristSet());
        MutableGristSet excessGrist = GristCache.addWithinCapacity(newCache, set, Echeladder.get(this.data).getGristCapacity());
        if (!excessGrist.equalContent(set)) {
            this.set(newCache);
            if (source != null) {
                GristToastPacket.notify(this.mcServer, this.data.identifier, set.mutableCopy().add(excessGrist.mutableCopy().scale(-1)), source);
            }
        }
        return excessGrist;
    }

    public void set(NonNegativeGristSet cache) {
        this.gristSet = cache.asImmutable();
        this.sendPacket(this.data.getPlayer());
    }

    void sendPacket(ServerPlayer player) {
        EditData data;
        if (player != null) {
            GristCachePacket packet = new GristCachePacket(this.getGristSet(), ClientPlayerData.CacheSource.PLAYER);
            player.connection.send((CustomPacketPayload)packet);
        }
        if ((data = ServerEditHandler.getData(this.mcServer, this.data.identifier)) != null) {
            data.sendGristCacheToEditor();
        }
    }

    private static MutableGristSet addWithinCapacity(MutableGristSet target, GristSet source, long capacity) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity under 0 not allowed.");
        }
        MutableGristSet remainder = MutableGristSet.newDefault();
        for (GristAmount amount : source.asAmounts()) {
            long remainingAmount;
            long toAdd;
            if (amount.amount() > 0L) {
                toAdd = Math.max(0L, Math.min(capacity - target.getGrist(amount.type()), amount.amount()));
                remainingAmount = amount.amount() - toAdd;
                if (toAdd != 0L) {
                    target.add(amount.type(), toAdd);
                }
                if (remainingAmount == 0L) continue;
                remainder.add(amount.type(), remainingAmount);
                continue;
            }
            if (amount.amount() >= 0L) continue;
            toAdd = Math.max(amount.amount(), Math.min(-target.getGrist(amount.type()), 0L));
            remainingAmount = amount.amount() - toAdd;
            if (toAdd != 0L) {
                target.add(amount.type(), toAdd);
            }
            if (remainingAmount == 0L) continue;
            remainder.add(amount.type(), remainingAmount);
        }
        return remainder;
    }
}

